package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets;

import com.yandex.direct.api.v5.dynamicfeedadtargets.AddRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamicfeedadtargets.DeleteRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.DeleteResponse;
import com.yandex.direct.api.v5.dynamicfeedadtargets.DynamicFeedAdTargetsPort;
import com.yandex.direct.api.v5.dynamicfeedadtargets.GetRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamicfeedadtargets.ResumeRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.ResumeResponse;
import com.yandex.direct.api.v5.dynamicfeedadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.SetBidsResponse;
import com.yandex.direct.api.v5.dynamicfeedadtargets.SuspendRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.SuspendResponse;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate.AddDynamicFeedAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate.DeleteDynamicFeedAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate.GetDynamicFeedAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate.ResumeDynamicFeedAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate.SetBidsDynamicFeedAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate.SuspendDynamicFeedAdTargetsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class DynamicFeedAdTargetsEndpoint implements DynamicFeedAdTargetsPort {
    private static final String SERVICE_NAME = "dynamicfeedadtargets";

    private final GenericApiService genericApiService;
    private final AddDynamicFeedAdTargetsDelegate addDynamicFeedAdTargetsDelegate;
    private final GetDynamicFeedAdTargetsDelegate getDynamicFeedAdTargetsDelegate;
    private final DeleteDynamicFeedAdTargetsDelegate deleteDynamicFeedAdTargetsDelegate;
    private final SuspendDynamicFeedAdTargetsDelegate suspendDynamicFeedAdTargetsDelegate;
    private final ResumeDynamicFeedAdTargetsDelegate resumeDynamicFeedAdTargetsDelegate;
    private final SetBidsDynamicFeedAdTargetsDelegate setBidsDynamicFeedAdTargetsDelegate;

    public DynamicFeedAdTargetsEndpoint(
            GenericApiService genericApiService,
            GetDynamicFeedAdTargetsDelegate getDynamicFeedAdTargetsDelegate,
            AddDynamicFeedAdTargetsDelegate addDynamicFeedAdTargetsDelegate,
            DeleteDynamicFeedAdTargetsDelegate deleteDynamicFeedAdTargetsDelegate,
            SuspendDynamicFeedAdTargetsDelegate suspendDynamicFeedAdTargetsDelegate,
            ResumeDynamicFeedAdTargetsDelegate resumeDynamicFeedAdTargetsDelegate,
            SetBidsDynamicFeedAdTargetsDelegate setBidsDynamicFeedAdTargetsDelegate) {
        this.genericApiService = genericApiService;
        this.getDynamicFeedAdTargetsDelegate = getDynamicFeedAdTargetsDelegate;
        this.addDynamicFeedAdTargetsDelegate = addDynamicFeedAdTargetsDelegate;
        this.deleteDynamicFeedAdTargetsDelegate = deleteDynamicFeedAdTargetsDelegate;
        this.suspendDynamicFeedAdTargetsDelegate = suspendDynamicFeedAdTargetsDelegate;
        this.resumeDynamicFeedAdTargetsDelegate = resumeDynamicFeedAdTargetsDelegate;
        this.setBidsDynamicFeedAdTargetsDelegate = setBidsDynamicFeedAdTargetsDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) {
        return genericApiService.doAction(addDynamicFeedAdTargetsDelegate, addRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) {
        return genericApiService.doAction(getDynamicFeedAdTargetsDelegate, getRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) {
        return genericApiService.doAction(deleteDynamicFeedAdTargetsDelegate, deleteRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "suspend")
    @ApiResponse
    @Override
    public SuspendResponse suspend(@ApiRequest SuspendRequest suspendRequest) {
        return genericApiService.doAction(suspendDynamicFeedAdTargetsDelegate, suspendRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "resume")
    @ApiResponse
    @Override
    public ResumeResponse resume(@ApiRequest ResumeRequest resumeRequest) {
        return genericApiService.doAction(resumeDynamicFeedAdTargetsDelegate, resumeRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "setBids")
    @ApiResponse
    @Override
    public SetBidsResponse setBids(@ApiRequest SetBidsRequest setBidsRequest) {
        return genericApiService.doAction(setBidsDynamicFeedAdTargetsDelegate, setBidsRequest);
    }
}
