package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.converter;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.yandex.direct.api.v5.dynamicfeedadtargets.SetBidsItem;
import com.yandex.direct.api.v5.dynamicfeedadtargets.SetBidsRequest;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bids.container.SetBidItem;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.util.Collections.emptyList;
import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToDbPrice;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class DynamicFeedAdTargetsSetBidsRequestConverter {
    public List<SetBidItem> convertSetBidsRequest(SetBidsRequest setBidsRequest) {
        if (setBidsRequest.getBids() == null) {
            return emptyList();
        }
        return mapList(setBidsRequest.getBids(), this::convertSetBidsItem);
    }

    @Nonnull
    private SetBidItem convertSetBidsItem(@Nullable SetBidsItem item) {
        // проверка на null есть в валидации запроса
        checkNotNull(item, "SetBidItem cannot be null");

        return new SetBidItem()
                .withId(item.getId())
                .withAdGroupId(item.getAdGroupId())
                .withCampaignId(item.getCampaignId())
                .withPriceSearch(convertToDbPrice(item.getBid()))
                .withPriceContext(convertToDbPrice(item.getContextBid()));
    }
}
