package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamicfeedadtargets.AddRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.converter.DynamicFeedAdTargetsAddRequestConverter;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.validation.DynamicFeedAdTargetsValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.DynamicFeedAdTargetsDefectTypes.DEFECT_PRESENTATIONS;

@Service
@ParametersAreNonnullByDefault
public class AddDynamicFeedAdTargetsDelegate
        extends OperationOnListDelegate<AddRequest, AddResponse, DynamicFeedAdTarget, Long> {
    private final DynamicFeedAdTargetsValidationService validationService;
    private final DynamicFeedAdTargetsAddRequestConverter requestConverter;
    private final ResultConverter resultConverter;
    private final DynamicTextAdTargetService dynamicAdTargetService;

    @Autowired
    public AddDynamicFeedAdTargetsDelegate(
            ApiAuthenticationSource auth,
            DynamicFeedAdTargetsValidationService validationService,
            DynamicFeedAdTargetsAddRequestConverter requestConverter,
            ResultConverter resultConverter,
            DynamicTextAdTargetService dynamicAdTargetService) {
        super(ApiPathConverter.forDynamicFeedAdTargets(), auth);
        this.validationService = validationService;
        this.requestConverter = requestConverter;
        this.resultConverter = resultConverter;
        this.dynamicAdTargetService = dynamicAdTargetService;
    }

    @Nullable
    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        return validationService.validateAddRequest(getClientId(), addRequest);
    }

    @Override
    public List<DynamicFeedAdTarget> convertRequest(AddRequest addRequest) {
        return requestConverter.convert(getClientId(), addRequest);
    }

    @Override
    public ApiMassResult<Long> processList(List<DynamicFeedAdTarget> validItems) {
        MassResult<Long> result =
                dynamicAdTargetService.addDynamicFeedAdTargets(getClientId(), getOperatorUid(), validItems);
        return resultConverter.toApiMassResult(result, DEFECT_PRESENTATIONS);
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new AddResponse().withAddResults(resultConverter.toActionResults(result, apiPathConverter));
    }

    private ClientId getClientId() {
        return auth.getChiefSubclient().getClientId();
    }

    private Long getOperatorUid() {
        return auth.getOperator().getUid();
    }
}
