package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamicfeedadtargets.DeleteRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.DeleteResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.BaseApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.validation.DynamicFeedAdTargetsValidationService;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.DynamicFeedAdTargetsDefectTypes.DEFECT_PRESENTATIONS;

@Service
@ParametersAreNonnullByDefault
public class DeleteDynamicFeedAdTargetsDelegate
        extends BaseApiServiceDelegate<DeleteRequest, DeleteResponse, List<Long>, ApiResult<Long>> {
    private final DynamicFeedAdTargetsValidationService validationService;
    private final DynamicTextAdTargetService dynamicTextAdTargetService;
    private final ResultConverter resultConverter;

    @Autowired
    public DeleteDynamicFeedAdTargetsDelegate(ApiAuthenticationSource auth,
                                              DynamicFeedAdTargetsValidationService validationService,
                                              DynamicTextAdTargetService dynamicTextAdTargetService,
                                              ResultConverter resultConverter) {
        super(ApiPathConverter.forDynamicFeedAdTargets(), auth);
        this.validationService = validationService;
        this.dynamicTextAdTargetService = dynamicTextAdTargetService;
        this.resultConverter = resultConverter;
    }

    @Nullable
    @Override
    public ValidationResult<DeleteRequest, DefectType> validateRequest(DeleteRequest deleteRequest) {
        return validationService.validateDeleteRequest(deleteRequest);
    }

    @Override
    public List<Long> convertRequest(DeleteRequest deleteRequest) {
        return deleteRequest.getSelectionCriteria().getIds();
    }

    @Override
    public ApiResult<List<ApiResult<Long>>> processRequest(List<Long> dynamicFeedAdTargetIds) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        Long operatorUid = auth.getOperator().getUid();
        MassResult<Long> result =
                dynamicTextAdTargetService.deleteDynamicAdTargets(operatorUid, clientId, dynamicFeedAdTargetIds);
        return resultConverter.toApiMassResult(result, DEFECT_PRESENTATIONS);
    }

    @Override
    public DeleteResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new DeleteResponse()
                .withDeleteResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
