package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamicfeedadtargets.DynamicFeedAdTargetFieldEnum;
import com.yandex.direct.api.v5.dynamicfeedadtargets.GetRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericGetRequest;
import ru.yandex.direct.api.v5.entity.GetApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.converter.GetRequestConverter;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.converter.GetResponseConverter;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.validation.DynamicFeedAdTargetsValidationService;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.dynamictextadtarget.container.DynamicTextAdTargetSelectionCriteria;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.result.ValidationResult;

@Service
@ParametersAreNonnullByDefault
public class GetDynamicFeedAdTargetsDelegate
        extends GetApiServiceDelegate<GetRequest,
        GetResponse,
        DynamicFeedAdTargetFieldEnum,
        DynamicTextAdTargetSelectionCriteria, //модель общая для Feed и Text динамических групп
        DynamicFeedAdTarget> {
    private final DynamicTextAdTargetService dynamicTextAdTargetService;
    private final DynamicFeedAdTargetsValidationService validationService;
    private final GetResponseConverter responseConverter;

    @Autowired
    public GetDynamicFeedAdTargetsDelegate(ApiAuthenticationSource auth,
                                           DynamicTextAdTargetService dynamicTextAdTargetService,
                                           DynamicFeedAdTargetsValidationService validationService,
                                           GetResponseConverter responseConverter) {
        super(ApiPathConverter.forDynamicFeedAdTargets(), auth);
        this.dynamicTextAdTargetService = dynamicTextAdTargetService;
        this.validationService = validationService;
        this.responseConverter = responseConverter;
    }

    @Nullable
    @Override
    public ValidationResult<GetRequest, DefectType> validateRequest(GetRequest getRequest) {
        return validationService.validateGetRequest(getRequest);
    }

    @Override
    public Set<DynamicFeedAdTargetFieldEnum> extractFieldNames(GetRequest getRequest) {
        return GetRequestConverter.getDynamicFeedAdTargetFieldEnums(getRequest);
    }

    @Override
    public DynamicTextAdTargetSelectionCriteria extractSelectionCriteria(GetRequest getRequest) {
        return GetRequestConverter.getDynamicTextAdTargetSelectionCriteria(getRequest);
    }

    @Override
    public List<DynamicFeedAdTarget> get(
            GenericGetRequest<DynamicFeedAdTargetFieldEnum, DynamicTextAdTargetSelectionCriteria> getRequest) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        Long operatorUid = auth.getOperator().getUid();

        DynamicTextAdTargetSelectionCriteria selection = getRequest.getSelectionCriteria();

        return dynamicTextAdTargetService.getDynamicFeedAdTargets(clientId, operatorUid, selection,
                getRequest.getLimitOffset());
    }

    @Override
    public GetResponse convertGetResponse(List<DynamicFeedAdTarget> dynamicFeedAdTargets,
                                          Set<DynamicFeedAdTargetFieldEnum> requestedFields,
                                          @Nullable Long limitedBy) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        return responseConverter.getGetResponse(clientId, dynamicFeedAdTargets, requestedFields, limitedBy);
    }
}
