package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamicfeedadtargets.ResumeRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.ResumeResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.validation.DynamicFeedAdTargetsValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetSuspendResumeService;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.DynamicFeedAdTargetsDefectTypes.DEFECT_PRESENTATIONS;

@Service
@ParametersAreNonnullByDefault
public class ResumeDynamicFeedAdTargetsDelegate
        extends OperationOnListDelegate<ResumeRequest, ResumeResponse, Long, Long> {
    private final DynamicFeedAdTargetsValidationService validationService;
    private final DynamicTextAdTargetSuspendResumeService suspendResumeService;
    private final ResultConverter resultConverter;

    @Autowired
    public ResumeDynamicFeedAdTargetsDelegate(ApiAuthenticationSource auth,
                                              DynamicFeedAdTargetsValidationService validationService,
                                              DynamicTextAdTargetSuspendResumeService suspendResumeService,
                                              ResultConverter resultConverter) {
        super(ApiPathConverter.forDynamicFeedAdTargets(), auth);
        this.validationService = validationService;
        this.suspendResumeService = suspendResumeService;
        this.resultConverter = resultConverter;
    }

    @Nullable
    @Override
    public ValidationResult<ResumeRequest, DefectType> validateRequest(ResumeRequest resumeRequest) {
        return validationService.validateResumeRequest(resumeRequest);
    }

    @Override
    public List<Long> convertRequest(ResumeRequest resumeRequest) {
        return resumeRequest.getSelectionCriteria().getIds();
    }

    @Override
    public ApiMassResult<Long> processList(List<Long> validIds) {
        var clientId = auth.getChiefSubclient().getClientId();
        var operatorUid = auth.getOperator().getUid();
        MassResult<Long> result = suspendResumeService.resumeDynamicFeedAdTargets(clientId, operatorUid, validIds);
        return resultConverter.toApiMassResult(result, DEFECT_PRESENTATIONS);
    }

    @Override
    public ResumeResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new ResumeResponse().withResumeResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
