package ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.delegate;


import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamicfeedadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.dynamicfeedadtargets.SetBidsResponse;
import com.yandex.direct.api.v5.general.SetBidsActionResult;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.converter.DynamicFeedAdTargetsSetBidsRequestConverter;
import ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.validation.DynamicFeedAdTargetsSetBidsValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.bids.container.SetBidItem;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicFeedAdTargetSetBidsService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamicfeedadtargets.DynamicFeedAdTargetsDefectTypes.DEFECT_PRESENTATIONS;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
@ParametersAreNonnullByDefault
public class SetBidsDynamicFeedAdTargetsDelegate
        extends OperationOnListDelegate<SetBidsRequest, SetBidsResponse, SetBidItem, SetBidItem> {
    private final DynamicFeedAdTargetsSetBidsValidationService validationService;
    private final ResultConverter resultConverter;
    private final DynamicFeedAdTargetsSetBidsRequestConverter requestConverter;
    private final DynamicFeedAdTargetSetBidsService service;

    public SetBidsDynamicFeedAdTargetsDelegate(ApiAuthenticationSource auth,
                                               DynamicFeedAdTargetsSetBidsValidationService validationService,
                                               ResultConverter resultConverter,
                                               DynamicFeedAdTargetsSetBidsRequestConverter requestConverter,
                                               DynamicFeedAdTargetSetBidsService service) {
        super(ApiPathConverter.forDynamicFeedAdTargetsSetBids(), auth);
        this.validationService = validationService;
        this.resultConverter = resultConverter;
        this.requestConverter = requestConverter;
        this.service = service;
    }

    @Nullable
    @Override
    public ValidationResult<SetBidsRequest, DefectType> validateRequest(SetBidsRequest setBidsRequest) {
        return validationService.validate(setBidsRequest);
    }

    @Override
    public List<SetBidItem> convertRequest(SetBidsRequest setBidsRequest) {
        return requestConverter.convertSetBidsRequest(setBidsRequest);
    }

    @Override
    public ApiMassResult<SetBidItem> processList(List<SetBidItem> validItems) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        Long operatorUid = auth.getOperator().getUid();
        MassResult<SetBidItem> result = service.setBids(clientId, operatorUid, validItems);
        return resultConverter.toApiMassResult(result, DEFECT_PRESENTATIONS);
    }

    @Override
    public SetBidsResponse convertResponse(ApiResult<List<ApiResult<SetBidItem>>> result) {
        List<SetBidsActionResult> setBidsActionResults =
                mapList(result.getResult(), r -> resultConverter.convertToSetBidsActionResult(r, apiPathConverter));
        return new SetBidsResponse().withSetBidsResults(setBidsActionResults);
    }
}
