package ru.yandex.direct.api.v5.entity.dynamictextadtargets;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

public interface DynamicAdTargetsDefectTranslations extends TranslationBundle {
    DynamicAdTargetsDefectTranslations INSTANCE = I18NBundle.implement(DynamicAdTargetsDefectTranslations.class);

    @MessageFormatStub("Условие не найдено")
    Translatable dynamicTextAdTargetNotFound();

    @MessageFormatStub("Условие нацеливания не найдено")
    Translatable dynamicTextAdTargetConditionNotFound();

    @MessageFormatStub("Кампания помещена в архив")
    Translatable archivedCampaignModification();

    @MessageFormatStub("Разрeшено удалять не более {0} условий в запросе")
    Translatable maxElementsPerDynamicAdTargetsDelete(Identity max);

    @MessageFormatStub("Разрeшено запускать не более {0} условий в запросе")
    Translatable maxDynamicTextAdTargetsPerResumeRequestDetailed(Identity max);

    @MessageFormatStub("Разрeшено останавливать не более {0} условий в запросе")
    Translatable maxDynamicTextAdTargetsPerSuspendRequestDetailed(Identity max);

    @MessageFormatStub("Разрeшено добавлять не более {0} условий в запросе")
    Translatable maxElementsPerDynamicAdTargetsAdd(Identity max);

    @MessageFormatStub("Количество правил в условии нацеливания должно быть от {0} до {1}")
    Translatable numberOfRulesInDynamicTextAdTarget(Identity min, Identity max);

    @MessageFormatStub("Правила в условии нацеливания должны быть уникальны")
    Translatable duplicateRulesInConditionsDetailed();

    @MessageFormatStub("Неправильный формат правила №{0}: задано неподдерживаемое отношение")
    Translatable invalidFormatWebpageConditionDetailed(Identity id);

    @MessageFormatStub("Неверный тип группы")
    Translatable invalidAdGroupTypeDetailed();

    @MessageFormatStub("Условия нацеливания в группе объявлений должны быть уникальны")
    Translatable dynamicConditionAlreadyExists();

    @MessageFormatStub("Условие нацеливания с правилом `Все страницы` не может комбинироваться с другими условиями в группе")
    Translatable allPageConditionCantBeWithAnotherCondition();

    @MessageFormatStub("Количество условий нацеливания в группе не может быть больше {0}")
    Translatable maxDynamicTextAdTargetsInAdGroup(Identity max);

    @MessageFormatStub("Условия нацеливания динамических текстовых объявлений разрешено добавлять только в группы объявлений с типом " +
            "DYNAMIC_TEXT_AD_GROUP и подтипом WEBPAGE")
    Translatable textFeedAdGroupTypeNotSupportedDetailed();

    @MessageFormatStub("Количество аргументов в правиле  №{0} условия нацеливания должно быть от {1} до {2}")
    Translatable numberOfArgumentsInRule(Identity id, Identity min, Identity max);

    @MessageFormatStub("Превышена максимальная длина значения №{0} правила №{1} в {2} символов")
    Translatable exceededMaxLengthInArguments(Identity argId, Identity ruleId, Identity max);

    @MessageFormatStub("Неправильный формат ссылки №{0} для правила №{1}")
    Translatable invalidUrlFormat(Identity argId, Identity ruleId);

    @MessageFormatStub("Неправильный формат правила: значение №{0} правила №{1} должно содержать хотя бы один значащий символ")
    Translatable invalidEmptyUrlFormat(Identity argId, Identity ruleId);

    @MessageFormatStub("В значении №{0} правила №{1} допускается использование букв латинского, турецкого, русского, украинского, казахского " +
            "алфавитов, цифр и знаков пунктуации.")
    Translatable invalidLettersInRule(Identity argId, Identity ruleId);

    @MessageFormatStub("Значение в поле Name не должно превышать {0} символов")
    Translatable exceededMaxLengthInName(Identity max);

    @MessageFormatStub("Не указано значение в поле Name")
    Translatable invalidEmptyNameFormat();

    @MessageFormatStub("В поле Name допускается использование букв латинского, турецкого, русского, украинского, казахского, белорусского " +
            "алфавитов, цифр и знаков пунктуации")
    Translatable invalidLettersInName();

    @MessageFormatStub("Группа объявлений не найдена")
    Translatable adGroupNotFoundDetailed();
    @MessageFormatStub("Условия для кампании {0} не найдены")
    Translatable dynamicTextAdTargetNotFoundInCampaign(Identity id);

    @MessageFormatStub("Условия для группы объявлений {0} не найдены")
    Translatable dynamicTextAdTargetNotFoundInAdGroup(Identity id);

    @MessageFormatStub("Условие нацеливания уже остановлено")
    Translatable dynamicTextAdTargetAlreadySuspended();

    @MessageFormatStub("Условие уже остановлено")
    Translatable dynamicTextAdTargetAlreadySuspendedDetailed();

    @MessageFormatStub("Условие нацеливания не остановлено")
    Translatable dynamicTextAdTargetIsNotSuspended();

    @MessageFormatStub("Условие не остановлено")
    Translatable dynamicTextAdTargetIsNotSuspendedDetailed();

    @MessageFormatStub("Id условия присутствует в запросе более одного раза")
    Translatable dynamicTextAdTargetIdInRequestMoreThanOnce();
}
