package ru.yandex.direct.api.v5.entity.dynamictextadtargets;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;

import static ru.yandex.direct.api.v5.validation.DefectTypeCreators.wrongSelectionCriteria;
import static ru.yandex.direct.api.v5.validation.DefectTypes.inconsistentState;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidCollectionSize;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidId;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notEligibleObject;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notFound;
import static ru.yandex.direct.api.v5.validation.DefectTypes.warningDuplicated;

public class DynamicAdTargetsDefectTypes {

    private static DynamicAdTargetsDefectTranslations translations() {
        return DynamicAdTargetsDefectTranslations.INSTANCE;
    }

    private static CommonDefectTranslations commonTranslations() {
        return CommonDefectTranslations.INSTANCE;
    }

    public static DefectType dynamicTextAdTargetsNotFound() {
        return notFound().withDetailedMessage(translations().dynamicTextAdTargetNotFound());
    }

    public static DefectType dynamicTextAdTargetsConditionNotFound() {
        return notFound().withDetailedMessage(translations().dynamicTextAdTargetConditionNotFound());
    }

    public static DefectType archivedCampaignModification() {
        return DefectTypes.badStatus()
                .withDetailedMessage((p, v) -> translations().archivedCampaignModification());
    }

    public static DefectType invalidIdInField() {
        return invalidId().withDetailedMessage((path, value) -> commonTranslations().fieldShouldBePositive("Id"));
    }

    public static DefectType invalidIdInFieldCommon() {
        return invalidId()
                .withDetailedMessage((path, value) -> commonTranslations().fieldShouldBePositive(path.toString()));
    }

    public static DefectType maxElementsPerDynamicAdTargetsAdd(int maxElements) {
        return DefectTypes.maxIdsInSelection()
                .withDetailedMessage(translations().maxElementsPerDynamicAdTargetsAdd(new Identity(maxElements)));
    }

    public static DefectType maxElementsPerDynamicAdTargetsDelete(int maxElements) {
        return DefectTypes.maxIdsInSelection()
                .withDetailedMessage(translations().maxElementsPerDynamicAdTargetsDelete(new Identity(maxElements)));
    }

    public static DefectType maxDynamicTextAdTargetsPerResumeRequest(int max) {
        return wrongSelectionCriteria()
                .withDetailedMessage(translations().maxDynamicTextAdTargetsPerResumeRequestDetailed(new Identity(max)));
    }

    public static DefectType maxDynamicTextAdTargetsPerSuspendRequest(int max) {
        return wrongSelectionCriteria()
                .withDetailedMessage(
                        translations().maxDynamicTextAdTargetsPerSuspendRequestDetailed(new Identity(max)));
    }

    public static DefectType numberOfRulesInDynamicTextAdTarget(int min, int max) {
        return invalidCollectionSize(min, max)
                .withDetailedMessage(
                        translations().numberOfRulesInDynamicTextAdTarget(new Identity(min), new Identity(max)));
    }

    public static DefectType duplicateRulesInConditions() {
        return DefectTypes.duplicatedObject()
                .withDetailedMessage((path, value) -> translations().duplicateRulesInConditionsDetailed());
    }

    public static DefectType invalidFormatWebpageCondition(int id) {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(
                        (path, value) -> translations().invalidFormatWebpageConditionDetailed(new Identity(id)));
    }

    public static DefectType invalidAdGroupType() {
        return inconsistentState()
                .withDetailedMessage(translations().invalidAdGroupTypeDetailed());
    }

    public static DefectType dynamicConditionAlreadyExists() {
        return inconsistentState()
                .withDetailedMessage(translations().dynamicConditionAlreadyExists());
    }

    public static DefectType allPageConditionCantBeWithAnotherCondition() {
        return inconsistentState()
                .withDetailedMessage(translations().allPageConditionCantBeWithAnotherCondition());
    }

    public static DefectType maxDynamicTextAdTargetsInAdGroup(int max) {
        return invalidCollectionSize()
                .withDetailedMessage(translations().maxDynamicTextAdTargetsInAdGroup(new Identity(max)));
    }

    public static DefectType textFeedAdGroupTypeNotSupported() {
        return notEligibleObject()
                .withDetailedMessage(translations().textFeedAdGroupTypeNotSupportedDetailed());
    }

    public static DefectType numberOfArgumentsInRule(int id, int min, int max) {
        return invalidCollectionSize(min, max)
                .withDetailedMessage(
                        translations().numberOfArgumentsInRule(new Identity(id), new Identity(min), new Identity(max)));
    }

    public static DefectType exceededMaxLengthInArguments(int ardId, int ruleId, int max) {
        return DefectTypes.maxStringSize(max)
                .withDetailedMessage(
                        translations().exceededMaxLengthInArguments(new Identity(ardId), new Identity(ruleId),
                                new Identity(max)));
    }

    public static DefectType invalidUrlFormat(int ardId, int ruleId) {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(
                        translations().invalidUrlFormat(new Identity(ardId), new Identity(ruleId)));
    }

    public static DefectType invalidEmptyUrlFormat(int ardId, int ruleId) {
        return DefectTypes.invalidValue()
                .withDetailedMessage(
                        translations().invalidEmptyUrlFormat(new Identity(ardId), new Identity(ruleId)));
    }

    public static DefectType invalidLettersInRule(int ardId, int ruleId) {
        return DefectTypes.invalidChars()
                .withDetailedMessage(
                        translations().invalidLettersInRule(new Identity(ardId), new Identity(ruleId)));
    }

    public static DefectType exceededMaxLengthInName(int max) {
        return DefectTypes.maxStringSize(max)
                .withDetailedMessage(
                        translations().exceededMaxLengthInName(new Identity(max)));
    }

    public static DefectType invalidEmptyNameFormat() {
        return DefectTypes.absentValueInField()
                .withDetailedMessage(
                        translations().invalidEmptyNameFormat());
    }

    public static DefectType invalidLettersInName() {
        return DefectTypes.invalidChars()
                .withDetailedMessage(
                        translations().invalidLettersInName());
    }

    public static DefectType adGroupNotFound() {
        return notFound().withDetailedMessage(translations().adGroupNotFoundDetailed());
    }

    public static DefectType invalidIdInFieldForSetBids() {
        return invalidId()
                .withDetailedMessage((path, value) -> commonTranslations().fieldShouldBePositive(path.toString()));
    }

    public static DefectType dynamicTextAdTargetNotFoundInCampaign(Long id) {
        return notFound()
                .withDetailedMessage(
                        (path, value) -> translations().dynamicTextAdTargetNotFoundInCampaign(Identity.of(id)));
    }

    public static DefectType dynamicTextAdTargetNotFoundInAdGroup(Long id) {
        return notFound()
                .withDetailedMessage(
                        (path, value) -> translations().dynamicTextAdTargetNotFoundInAdGroup(Identity.of(id)));
    }

    public static DefectType dynamicTextAdTargetAlreadySuspended() {
        return new DefectType(10242,
                translations().dynamicTextAdTargetAlreadySuspended(),
                translations().dynamicTextAdTargetAlreadySuspendedDetailed());
    }

    public static DefectType dynamicTextAdTargetIsNotSuspended() {
        return new DefectType(10243,
                translations().dynamicTextAdTargetIsNotSuspended(),
                translations().dynamicTextAdTargetIsNotSuspendedDetailed());
    }

    public static DefectType dynamicTextAdTargetIdInRequestMoreThanOnce() {
        return warningDuplicated().withDetailedMessage(translations().dynamicTextAdTargetIdInRequestMoreThanOnce());
    }
}
