package ru.yandex.direct.api.v5.entity.dynamictextadtargets;

import com.yandex.direct.api.v5.dynamictextadtargets.AddRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.DeleteRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.DeleteResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.DynamicTextAdTargetsPort;
import com.yandex.direct.api.v5.dynamictextadtargets.GetRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.ResumeRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.ResumeResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.SetBidsRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.SetBidsResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.SuspendRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.SuspendResponse;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate.AddDynamicTextAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate.DeleteDynamicTextAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate.GetDynamicTextAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate.ResumeDynamicTextAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate.SetBidsDynamicTextAdTargetsDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate.SuspendDynamicTextAdTargetsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

/**
 * Сервис для работы с условиями нацеливания для динамических объявлений.
 *
 * @see
 * <a href=https://tech.yandex.ru/direct/doc/ref-v5/dynamictextadtargets/dynamictextadtargets-docpage/>DynamicTextAdTargets API tech docs</a>
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class DynamicTextAdTargetsEndpoint implements DynamicTextAdTargetsPort {
    private static final String SERVICE_NAME = "dynamictextadtargets";

    private final GenericApiService genericApiService;
    private final GetDynamicTextAdTargetsDelegate getDynamicTextAdTargetsDelegate;
    private final DeleteDynamicTextAdTargetsDelegate deleteDynamicTextAdTargetsDelegate;
    private final AddDynamicTextAdTargetsDelegate addDynamicTextAdTargetsDelegate;
    private final SetBidsDynamicTextAdTargetsDelegate setBidsDynamicTextAdTargetsDelegate;
    private final ResumeDynamicTextAdTargetsDelegate resumeDynamicTextAdTargetsDelegate;
    private final SuspendDynamicTextAdTargetsDelegate suspendDynamicTextAdTargetsDelegate;

    public DynamicTextAdTargetsEndpoint(
            GenericApiService genericApiService,
            GetDynamicTextAdTargetsDelegate getDynamicTextAdTargetsDelegate,
            DeleteDynamicTextAdTargetsDelegate deleteDynamicTextAdTargetsDelegate,
            AddDynamicTextAdTargetsDelegate addDynamicTextAdTargetsDelegate,
            SetBidsDynamicTextAdTargetsDelegate setBidsDynamicTextAdTargetsDelegate,
            ResumeDynamicTextAdTargetsDelegate resumeDynamicTextAdTargetsDelegate,
            SuspendDynamicTextAdTargetsDelegate suspendDynamicTextAdTargetsDelegate) {
        this.genericApiService = genericApiService;
        this.getDynamicTextAdTargetsDelegate = getDynamicTextAdTargetsDelegate;
        this.setBidsDynamicTextAdTargetsDelegate = setBidsDynamicTextAdTargetsDelegate;
        this.deleteDynamicTextAdTargetsDelegate = deleteDynamicTextAdTargetsDelegate;
        this.addDynamicTextAdTargetsDelegate = addDynamicTextAdTargetsDelegate;
        this.resumeDynamicTextAdTargetsDelegate = resumeDynamicTextAdTargetsDelegate;
        this.suspendDynamicTextAdTargetsDelegate = suspendDynamicTextAdTargetsDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) {
        return genericApiService.doAction(addDynamicTextAdTargetsDelegate, addRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) {
        return genericApiService.doAction(getDynamicTextAdTargetsDelegate, getRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) {
        return genericApiService.doAction(deleteDynamicTextAdTargetsDelegate, deleteRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "suspend")
    @ApiResponse
    @Override
    public SuspendResponse suspend(@ApiRequest SuspendRequest suspendRequest) {
        return genericApiService.doAction(suspendDynamicTextAdTargetsDelegate, suspendRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "resume")
    @ApiResponse
    @Override
    public ResumeResponse resume(@ApiRequest ResumeRequest resumeRequest) {
        return genericApiService.doAction(resumeDynamicTextAdTargetsDelegate, resumeRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "setBids")
    @ApiResponse
    @Override
    public SetBidsResponse setBids(@ApiRequest SetBidsRequest setBidsRequest) {
        return genericApiService.doAction(setBidsDynamicTextAdTargetsDelegate, setBidsRequest);
    }
}
