package ru.yandex.direct.api.v5.entity.dynamictextadtargets.converter;

import com.google.common.collect.ImmutableMap;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageCondition;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleKind;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleType;
import ru.yandex.direct.utils.converter.Converters;

public class AddRequestWebpageRuleConverter {
    private static final ImmutableMap<WebpageConditionOperandEnum, WebpageRuleType> EXTERNAL_TO_INTERNAL_OPERAND =
            ImmutableMap.<WebpageConditionOperandEnum, WebpageRuleType>builder()
                    .put(WebpageConditionOperandEnum.PAGE_CONTENT, WebpageRuleType.CONTENT)
                    .put(WebpageConditionOperandEnum.DOMAIN, WebpageRuleType.DOMAIN)
                    .put(WebpageConditionOperandEnum.PAGE_TITLE, WebpageRuleType.TITLE)
                    .put(WebpageConditionOperandEnum.URL, WebpageRuleType.URL)
                    .put(WebpageConditionOperandEnum.OFFERS_LIST_URL, WebpageRuleType.URL_PRODLIST)
                    .build();

    private static final ImmutableMap<StringConditionOperatorEnum, WebpageRuleKind> EXTERNAL_TO_INTERNAL_OPERATOR =
            ImmutableMap.<StringConditionOperatorEnum, WebpageRuleKind>builder()
                    .put(StringConditionOperatorEnum.EQUALS_ANY, WebpageRuleKind.EQUALS)
                    .put(StringConditionOperatorEnum.NOT_EQUALS_ALL, WebpageRuleKind.NOT_EQUALS)
                    .put(StringConditionOperatorEnum.CONTAINS_ANY, WebpageRuleKind.EXACT)
                    .put(StringConditionOperatorEnum.NOT_CONTAINS_ALL, WebpageRuleKind.NOT_EXACT)
                    .build();

    protected static WebpageRule convertWebpageCondition(WebpageCondition condition) {
        return new WebpageRule()
                .withKind(convertRuleOperator(condition.getOperator()))
                .withType(convertRuleOperand(condition.getOperand()))
                .withValue(condition.getArguments());
    }

    protected static WebpageRuleType convertRuleOperand(WebpageConditionOperandEnum type) {
        return Converters.mappingValueConverter(EXTERNAL_TO_INTERNAL_OPERAND).convert(type);
    }

    protected static WebpageRuleKind convertRuleOperator(StringConditionOperatorEnum kind) {
        return Converters.mappingValueConverter(EXTERNAL_TO_INTERNAL_OPERATOR).convert(kind);
    }

}
