package ru.yandex.direct.api.v5.entity.dynamictextadtargets.converter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTargetState;
import ru.yandex.direct.utils.converter.Converters;

public class GetRequestConverter {

    private static final Set<DynamicTextAdTargetState> ALL_STATES = ImmutableSet.of(
            DynamicTextAdTargetState.ON,
            DynamicTextAdTargetState.OFF,
            DynamicTextAdTargetState.SUSPENDED,
            DynamicTextAdTargetState.DELETED);

    private static final ImmutableMap<AdTargetStateSelectionEnum, DynamicTextAdTargetState> EXTERNAL_TO_INTERNAL_STATES =
            ImmutableMap.<AdTargetStateSelectionEnum, DynamicTextAdTargetState>builder()
                    .put(AdTargetStateSelectionEnum.OFF, DynamicTextAdTargetState.OFF)
                    .put(AdTargetStateSelectionEnum.ON, DynamicTextAdTargetState.ON)
                    .put(AdTargetStateSelectionEnum.SUSPENDED, DynamicTextAdTargetState.SUSPENDED)
                    .put(AdTargetStateSelectionEnum.DELETED, DynamicTextAdTargetState.DELETED)
                    .build();

    public static Set<DynamicTextAdTargetState> convertStates(List<AdTargetStateSelectionEnum> states,
                                                              boolean idsIsEmpty) {

        Set<DynamicTextAdTargetState> resultStates =
                Converters.immutableSetConverter(EXTERNAL_TO_INTERNAL_STATES).convert(states);

        // Если набор стейтов не задан явно выбираем все, кроме удаленных см. DIRECT-48849
        // За исключением случаев когда явно задан список Id условий, тогда выбираем
        // и удаленные тоже

        if (!resultStates.isEmpty()) {
            return resultStates;
        }

        if (!idsIsEmpty) {
            return ALL_STATES;
        }

        return ALL_STATES.stream()
                .filter(state -> state != DynamicTextAdTargetState.DELETED)
                .collect(Collectors.toSet());
    }
}
