package ru.yandex.direct.api.v5.entity.dynamictextadtargets.converter;

import com.google.common.collect.ImmutableMap;
import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageCondition;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleKind;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleType;
import ru.yandex.direct.utils.converter.Converters;

public class GetResponseWebpageRuleConverter {

    private static final ImmutableMap<WebpageRuleType, WebpageConditionOperandEnum> INTERNAL_TO_EXTERNAL_OPERAND =
            ImmutableMap.<WebpageRuleType, WebpageConditionOperandEnum>builder()
                    .put(WebpageRuleType.CONTENT, WebpageConditionOperandEnum.PAGE_CONTENT)
                    .put(WebpageRuleType.DOMAIN, WebpageConditionOperandEnum.DOMAIN)
                    .put(WebpageRuleType.TITLE, WebpageConditionOperandEnum.PAGE_TITLE)
                    .put(WebpageRuleType.URL, WebpageConditionOperandEnum.URL)
                    .put(WebpageRuleType.URL_PRODLIST, WebpageConditionOperandEnum.OFFERS_LIST_URL)
                    .build();

    private static final ImmutableMap<WebpageRuleKind, StringConditionOperatorEnum> INTERNAL_TO_EXTERNAL_OPERATOR =
            ImmutableMap.<WebpageRuleKind, StringConditionOperatorEnum>builder()
                    .put(WebpageRuleKind.EQUALS, StringConditionOperatorEnum.EQUALS_ANY)
                    .put(WebpageRuleKind.NOT_EQUALS, StringConditionOperatorEnum.NOT_EQUALS_ALL)
                    .put(WebpageRuleKind.EXACT, StringConditionOperatorEnum.CONTAINS_ANY)
                    .put(WebpageRuleKind.NOT_EXACT, StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                    .build();

    protected static WebpageCondition convertWebpageRule(WebpageRule rule) {
        return new WebpageCondition()
                .withOperand(convertRuleOperand(rule.getType()))
                .withOperator(convertRuleOperator(rule.getKind()))
                .withArguments(rule.getValue());
    }

    protected static WebpageConditionOperandEnum convertRuleOperand(WebpageRuleType type) {
        return Converters.mappingValueConverter(INTERNAL_TO_EXTERNAL_OPERAND).convert(type);
    }

    protected static StringConditionOperatorEnum convertRuleOperator(WebpageRuleKind kind) {
        return Converters.mappingValueConverter(INTERNAL_TO_EXTERNAL_OPERATOR).convert(kind);
    }
}
