package ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamictextadtargets.AddRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.converter.DynamicTextAdTargetsAddRequestConverter;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation.DynamicTextAdTargetsAddRequestValidator;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetService;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefectIds;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.result.DefectIds;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation.DynamicTextAdTargetsDefectPresentations.DEFECT_PRESENTATIONS_HOLDER;

@Service
@ParametersAreNonnullByDefault
public class AddDynamicTextAdTargetsDelegate
        extends OperationOnListDelegate<AddRequest, AddResponse, DynamicTextAdTarget, Long> {

    private static final DefectPresentationsHolder CUSTOM_HOLDER =
            DefectPresentationsHolder.builderWithFallback(DEFECT_PRESENTATIONS_HOLDER)
                    .register(DefectIds.MUST_BE_VALID_ID,
                            DynamicAdTargetsDefectTypes.invalidIdInFieldCommon())
                    .register(DefectIds.INCONSISTENT_STATE,
                            DynamicAdTargetsDefectTypes.invalidAdGroupType())
                    .register(DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS,
                            DynamicAdTargetsDefectTypes.dynamicConditionAlreadyExists())
                    .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS,
                            DynamicAdTargetsDefectTypes.duplicateRulesInConditions())
                    .register(DynamicTextAdTargetDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE,
                            DynamicAdTargetsDefectTypes.textFeedAdGroupTypeNotSupported())
                    .register(DynamicTextAdTargetDefectIds.Gen.ALL_PAGE_CONDITION_NOT_WITH_ANOTHER,
                            DynamicAdTargetsDefectTypes.allPageConditionCantBeWithAnotherCondition())
                    .register(DynamicTextAdTargetDefectIds.Num.MAX_COUNT_IN_ADGROUP,
                            t -> DynamicAdTargetsDefectTypes.maxDynamicTextAdTargetsInAdGroup(t.getMax().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Num.NUMBER_OF_RULES_MUST_BE_FROM_TO,
                            t -> DynamicAdTargetsDefectTypes.numberOfRulesInDynamicTextAdTarget(t.getMin().intValue(),
                                    t.getMax().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Num.INVALID_FORMAT_WEBPAGE_CONDITION,
                            t -> DynamicAdTargetsDefectTypes.invalidFormatWebpageCondition(t.getMax().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Gen.DUPLICATE_RULES_IN_CONDITION,
                            t -> DynamicAdTargetsDefectTypes.duplicateRulesInConditions())
                    .build();

    private final DynamicTextAdTargetsAddRequestValidator requestValidator;
    private final DynamicTextAdTargetsAddRequestConverter requestConverter;
    private final ResultConverter resultConverter;
    private final DynamicTextAdTargetService service;

    @Autowired
    public AddDynamicTextAdTargetsDelegate(
            ApiAuthenticationSource auth,
            DynamicTextAdTargetsAddRequestValidator requestValidator,
            DynamicTextAdTargetsAddRequestConverter requestConverter,
            ResultConverter resultConverter,
            DynamicTextAdTargetService service) {
        super(ApiPathConverter.forDynamicTextAdTargets(), auth);
        this.requestValidator = requestValidator;
        this.requestConverter = requestConverter;
        this.resultConverter = resultConverter;
        this.service = service;
    }

    @Nullable
    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        return requestValidator.validateRequest(addRequest);
    }

    @Override
    public List<DynamicTextAdTarget> convertRequest(AddRequest addRequest) {
        return requestConverter.convert(getClientId(), addRequest);
    }

    @Override
    public ApiMassResult<Long> processList(List<DynamicTextAdTarget> validItems) {
        MassResult<Long> result = service.addDynamicTextAdTargets(getClientId(), getOperatorUid(), validItems);
        return resultConverter.toApiMassResult(result, CUSTOM_HOLDER);
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new AddResponse().withAddResults(resultConverter.toActionResults(result, apiPathConverter));
    }

    private ClientId getClientId() {
        return auth.getChiefSubclient().getClientId();
    }

    private Long getOperatorUid() {
        return auth.getOperator().getUid();
    }
}
