package ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate;


import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamictextadtargets.GetRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.GetResponse;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.general.AdTargetsSelectionCriteria;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.EnumPropertyFilter;
import ru.yandex.direct.api.v5.entity.GenericGetRequest;
import ru.yandex.direct.api.v5.entity.GetApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.container.DynamicTextAdTargetGetContainer;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.converter.GetRequestConverter;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.converter.GetResponseConverter;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation.DynamicTextAdTargetsGetRequestValidator;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.util.PropertyFilter;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.service.CampaignService;
import ru.yandex.direct.core.entity.dynamictextadtarget.container.DynamicTextAdTargetSelectionCriteria;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
@Component
public class GetDynamicTextAdTargetsDelegate extends
        GetApiServiceDelegate<GetRequest, GetResponse, WebpageFieldEnum, DynamicTextAdTargetSelectionCriteria,
                DynamicTextAdTargetGetContainer> {

    private final DynamicTextAdTargetService dynamicTextAdTargetService;
    private final CampaignService campaignService;
    private final EnumPropertyFilter<WebpageFieldEnum> propertyFilter;
    private final GetResponseConverter getResponseConverter;
    private final DynamicTextAdTargetsGetRequestValidator requestValidator;

    public GetDynamicTextAdTargetsDelegate(ApiAuthenticationSource auth,
                                           DynamicTextAdTargetService dynamicTextAdTargetService,
                                           CampaignService campaignService,
                                           PropertyFilter propertyFilter,
                                           GetResponseConverter getResponseConverter,
                                           DynamicTextAdTargetsGetRequestValidator requestValidator) {
        super(MappingPathConverter.builder(GetDynamicTextAdTargetsDelegate.class, "capitalize")
                .build(), auth);
        this.dynamicTextAdTargetService = dynamicTextAdTargetService;
        this.campaignService = campaignService;
        this.propertyFilter = EnumPropertyFilter.from(WebpageFieldEnum.class, propertyFilter);
        this.getResponseConverter = getResponseConverter;
        this.requestValidator = requestValidator;
    }

    @Nullable
    @Override
    public ValidationResult<GetRequest, DefectType> validateRequest(GetRequest externalRequest) {
        return requestValidator.validate(externalRequest);
    }

    @Override
    public Set<WebpageFieldEnum> extractFieldNames(GetRequest externalRequest) {
        return new HashSet<>(externalRequest.getFieldNames());
    }

    @Override
    public DynamicTextAdTargetSelectionCriteria extractSelectionCriteria(GetRequest externalRequest) {
        AdTargetsSelectionCriteria selectionCriteria = externalRequest.getSelectionCriteria();
        List<Long> ids = selectionCriteria.getIds();

        return new DynamicTextAdTargetSelectionCriteria()
                .withConditionIds(new HashSet<>(ids))
                .withAdGroupIds(new HashSet<>(selectionCriteria.getAdGroupIds()))
                .withCampaignIds(new HashSet<>(selectionCriteria.getCampaignIds()))
                .withStates(GetRequestConverter.convertStates(selectionCriteria.getStates(), ids.isEmpty()));
    }

    @Override
    public List<DynamicTextAdTargetGetContainer> get(
            GenericGetRequest<WebpageFieldEnum, DynamicTextAdTargetSelectionCriteria> getRequest) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        Long operatorUid = auth.getOperator().getUid();

        DynamicTextAdTargetSelectionCriteria selection = getRequest.getSelectionCriteria();

        List<DynamicTextAdTarget> dynamicTextAdTargets = dynamicTextAdTargetService
                .getDynamicTextAdTargets(clientId, operatorUid, selection, getRequest.getLimitOffset());

        return convertDynamicTextAdTargetsToContainers(clientId, dynamicTextAdTargets);
    }

    @Override
    public GetResponse convertGetResponse(List<DynamicTextAdTargetGetContainer> result,
                                          Set<WebpageFieldEnum> requestedFields,
                                          @Nullable Long limitedBy) {
        GetResponse response = new GetResponse().withLimitedBy(limitedBy);

        List<WebpageGetItem> getItems = mapList(result, getResponseConverter::convert);
        propertyFilter.filterProperties(getItems, requestedFields);
        if (!getItems.isEmpty()) {
            response.withWebpages(getItems);
        }
        return response;
    }

    private List<DynamicTextAdTargetGetContainer> convertDynamicTextAdTargetsToContainers(ClientId clientId,
                                                                                          List<DynamicTextAdTarget> dynamicTextAdTargets) {
        List<Long> campaignIds = mapList(dynamicTextAdTargets, DynamicTextAdTarget::getCampaignId);
        List<Campaign> campaigns = campaignService.getCampaigns(clientId, campaignIds);
        Map<Long, Campaign> campaignById = listToMap(campaigns, Campaign::getId);

        return mapList(dynamicTextAdTargets,
                condition -> new DynamicTextAdTargetGetContainer()
                        .withDynamicTextAdTarget(condition)
                        .withCampaign(campaignById.get(condition.getCampaignId())));
    }
}
