package ru.yandex.direct.api.v5.entity.dynamictextadtargets.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamictextadtargets.SuspendRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.SuspendResponse;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation.DynamicTextAdTargetsSuspendResumeRequestValidator;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetSuspendResumeService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.result.PathConverter;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation.DynamicTextAdTargetsDefectPresentations.DEFECT_PRESENTATIONS_HOLDER;

@Component
@ParametersAreNonnullByDefault
public class SuspendDynamicTextAdTargetsDelegate
        extends OperationOnListDelegate<SuspendRequest, SuspendResponse, Long, Long> {

    private static final DefectPresentationsHolder DYNAMIC_TEXT_AD_TARGETS_SUSPEND_CUSTOM_DEFECT_PRESENTATIONS =
            DefectPresentationsHolder.builderWithFallback(DEFECT_PRESENTATIONS_HOLDER)
                    .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
                            DynamicAdTargetsDefectTypes.dynamicTextAdTargetIdInRequestMoreThanOnce())
                    .build();

    private final ResultConverter resultConverter;
    private final DynamicTextAdTargetSuspendResumeService service;
    private final DynamicTextAdTargetsSuspendResumeRequestValidator requestValidator;

    public SuspendDynamicTextAdTargetsDelegate(ApiAuthenticationSource auth,
                                               ResultConverter resultConverter,
                                               DynamicTextAdTargetSuspendResumeService service,
                                               DynamicTextAdTargetsSuspendResumeRequestValidator requestValidator) {
        super(PathConverter.identity(), auth);
        this.resultConverter = resultConverter;
        this.service = service;
        this.requestValidator = requestValidator;
    }

    @Nullable
    @Override
    public ValidationResult<SuspendRequest, DefectType> validateRequest(SuspendRequest externalRequest) {
        return requestValidator.validate(externalRequest);
    }

    @Override
    public List<Long> convertRequest(SuspendRequest externalRequest) {
        return externalRequest.getSelectionCriteria().getIds();
    }

    @Override
    public SuspendResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new SuspendResponse().withSuspendResults(resultConverter.toActionResults(result, apiPathConverter));
    }

    @Override
    public ApiMassResult<Long> processList(List<Long> validIds) {
        MassResult<Long> result = service.suspendDynamicTextAdTargets(getClientId(), getOperatorUid(), validIds);
        return resultConverter.toApiMassResult(result, DYNAMIC_TEXT_AD_TARGETS_SUSPEND_CUSTOM_DEFECT_PRESENTATIONS);

    }

    private ClientId getClientId() {
        return auth.getChiefSubclient().getClientId();
    }

    private Long getOperatorUid() {
        return auth.getOperator().getUid();
    }
}
