package ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamictextadtargets.AddRequest;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.maxElementsPerDynamicAdTargetsAdd;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;

@Component
@ParametersAreNonnullByDefault
public class DynamicTextAdTargetsAddRequestValidator {

    private static final int MAX_ELEMENTS_PER_ADD = 1_000;

    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        ItemValidationBuilder<AddRequest, DefectType> vb = ItemValidationBuilder.of(addRequest);
        vb.item(addRequest.getWebpages(), AddRequest.PropInfo.WEBPAGES.schemaName.getLocalPart())
                .check(maxListSize(MAX_ELEMENTS_PER_ADD), maxElementsPerDynamicAdTargetsAdd(MAX_ELEMENTS_PER_ADD));
        return vb.getResult();
    }
}
