package ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation;

import ru.yandex.direct.api.v5.common.validation.DefaultApiPresentations;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes;
import ru.yandex.direct.core.entity.bids.container.ExternalFieldsBidsMapping;
import ru.yandex.direct.core.entity.bids.container.SetBidItem;
import ru.yandex.direct.core.entity.bids.validation.BidsDefects;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefectIds;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.DefectIds;

import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidMustBeNotGreaterThan;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidMustBeNotLessThan;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidWontBeAcceptedInCaseOfAutoBudgetStrategy;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.bidWontBeAcceptedInCaseOfContextIsServingOff;
import static ru.yandex.direct.api.v5.entity.bids.validation.BidsDefectTypes.priorityWontBeAcceptedNotAutoBudgetStrategy;

public class DynamicTextAdTargetsDefectPresentations {
    public static final DefectPresentationsHolder DEFECT_PRESENTATIONS_HOLDER =
            DefectPresentationsHolder.builderWithFallback(DefaultApiPresentations.HOLDER)
                    .register(DefectIds.OBJECT_NOT_FOUND,
                            DynamicAdTargetsDefectTypes.dynamicTextAdTargetsNotFound())
                    .register(DefectIds.MUST_BE_VALID_ID,
                            DynamicAdTargetsDefectTypes.invalidIdInField())
                    .register(CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION,
                            DynamicAdTargetsDefectTypes.archivedCampaignModification())
                    .register(BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY,
                            t -> bidWontBeAcceptedInCaseOfAutoBudgetStrategy())
                    .register(BidsDefects.Ids.PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY,
                            t -> priorityWontBeAcceptedNotAutoBudgetStrategy())
                    .register(BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF,
                            t -> bidWontBeAcceptedInCaseOfContextIsServingOff())
                    .register(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN,
                            t -> bidMustBeNotLessThan(t.getMoneyValue().getCurrencyCode().getTranslation().longForm(),
                                    Identity.of(t.getMoneyValue().micros())))
                    .register(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX,
                            t -> bidMustBeNotGreaterThan(
                                    t.getMoneyValue().getCurrencyCode().getTranslation().longForm(),
                                    Identity.of(t.getMoneyValue().micros())))
                    .register(DynamicTextAdTargetDefectIds.Strings.NUMBER_ARGUMENTS_MUST_BE_FROM_TO,
                            t -> DynamicAdTargetsDefectTypes
                                    .numberOfArgumentsInRule(t.getId1().intValue(), t.getMin().intValue(),
                                            t.getMax().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS,
                            t -> DynamicAdTargetsDefectTypes
                                    .exceededMaxLengthInArguments(t.getId1().intValue(), t.getId2().intValue(),
                                            t.getMax().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Strings.INVALID_URL_FORMAT,
                            t -> DynamicAdTargetsDefectTypes
                                    .invalidUrlFormat(t.getId1().intValue(), t.getId2().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_URL_FORMAT,
                            t -> DynamicAdTargetsDefectTypes
                                    .invalidEmptyUrlFormat(t.getId1().intValue(), t.getId2().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_RULE,
                            t -> DynamicAdTargetsDefectTypes
                                    .invalidLettersInRule(t.getId1().intValue(), t.getId2().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_NAME,
                            t -> DynamicAdTargetsDefectTypes
                                    .exceededMaxLengthInName(t.getMax().intValue()))
                    .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_NAME_FORMAT,
                            t -> DynamicAdTargetsDefectTypes
                                    .invalidEmptyNameFormat())
                    .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_NAME,
                            t -> DynamicAdTargetsDefectTypes
                                    .invalidLettersInName())
                    .register(DynamicTextAdTargetDefectIds.Gen.ALL_PAGE_CONDITION_NOT_WITH_ANOTHER,
                            t -> DynamicAdTargetsDefectTypes.allPageConditionCantBeWithAnotherCondition())
                    .register(DynamicTextAdTargetDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE,
                            t -> DynamicAdTargetsDefectTypes.textFeedAdGroupTypeNotSupported())
                    .register(DynamicTextAdTargetDefectIds.Gen.AD_GROUP_NOT_FOUND,
                            t -> DynamicAdTargetsDefectTypes.adGroupNotFound())
                    .build();

    public static final ExternalFieldsBidsMapping DYNAMIC_TEXT_AD_TARGETS_IDS_MAPPING =
            ExternalFieldsBidsMapping.builder()
                    .map(SetBidItem.ID, "Id")
                    .map(SetBidItem.CAMPAIGN_ID, "CampaignId")
                    .map(SetBidItem.AD_GROUP_ID, "AdGroupId")
                    .map(SetBidItem.PRICE_CONTEXT, "ContextBid")
                    .map(SetBidItem.PRICE_SEARCH, "Bid")
                    .map(SetBidItem.AUTOBUDGET_PRIORITY, "StrategyPriority")
                    .build();
}
