package ru.yandex.direct.api.v5.entity.dynamictextadtargets.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamictextadtargets.ResumeRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.SuspendRequest;
import com.yandex.direct.api.v5.general.IdsCriteria;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.maxDynamicTextAdTargetsPerResumeRequest;
import static ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes.maxDynamicTextAdTargetsPerSuspendRequest;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.eachNotNull;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.notEmptyCollection;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.notNull;

@Component
@ParametersAreNonnullByDefault
public class DynamicTextAdTargetsSuspendResumeRequestValidator {

    public static final int MAX_SUSPEND_RESUME_IDS_COUNT = 10_000;

    public ValidationResult<ResumeRequest, DefectType> validate(ResumeRequest externalRequest) {

        ItemValidationBuilder<ResumeRequest, DefectType> vb = ItemValidationBuilder.of(externalRequest);
        vb.item(externalRequest.getSelectionCriteria(),
                ResumeRequest.PropInfo.SELECTION_CRITERIA.schemaName.getLocalPart())
                .check(notNull())
                .checkBy(idsCriteria -> validateIdsCriteria(idsCriteria, true), When.isValid());
        return vb.getResult();
    }

    public ValidationResult<SuspendRequest, DefectType> validate(SuspendRequest externalRequest) {

        ItemValidationBuilder<SuspendRequest, DefectType> vb = ItemValidationBuilder.of(externalRequest);
        vb.item(externalRequest.getSelectionCriteria(),
                ResumeRequest.PropInfo.SELECTION_CRITERIA.schemaName.getLocalPart())
                .check(notNull())
                .checkBy(idsCriteria -> validateIdsCriteria(idsCriteria, false), When.isValid());
        return vb.getResult();
    }

    private ValidationResult<IdsCriteria, DefectType> validateIdsCriteria(IdsCriteria idsCriteria, boolean resume) {
        ItemValidationBuilder<IdsCriteria, DefectType> vb = ItemValidationBuilder.of(idsCriteria);
        vb.item(idsCriteria.getIds(), "Ids")
                .check(notNull(), When.isValid())
                .check(notEmptyCollection(), When.isValid())
                .check(eachNotNull(), When.isValid())
                .check(maxListSize(MAX_SUSPEND_RESUME_IDS_COUNT),
                        resume
                                ? maxDynamicTextAdTargetsPerResumeRequest(MAX_SUSPEND_RESUME_IDS_COUNT)
                                : maxDynamicTextAdTargetsPerSuspendRequest(MAX_SUSPEND_RESUME_IDS_COUNT),
                        When.isValid());

        return vb.getResult();
    }
}
