package ru.yandex.direct.api.v5.entity.features;

import com.yandex.direct.api.v5.features.ApiException;
import com.yandex.direct.api.v5.features.FeaturesPort;
import com.yandex.direct.api.v5.features.GetRequest;
import com.yandex.direct.api.v5.features.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.features.delegate.GetFeaturesDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

/**
 * Сервис по работе с фичами.
 *
 * (!) Этот сервис не публичный, используется только для внутренних запросов в Директ.Коммандере.
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class FeaturesEndpoint implements FeaturesPort {

    public static final PathConverter PATH_CONVERTER = MappingPathConverter.builder(FeaturesEndpoint.class, "")
            .add(ApiPathConverter.getCommonDict())
            .build();

    private static final String SERVICE_NAME = "features";

    private final GenericApiService genericApiService;
    private final GetFeaturesDelegate getDelegate;

    @Autowired
    public FeaturesEndpoint(GenericApiService genericApiService, GetFeaturesDelegate getDelegate) {
        this.genericApiService = genericApiService;
        this.getDelegate = getDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getDelegate, getRequest);
    }
}
