package ru.yandex.direct.api.v5.entity.features.delegate;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.features.FeatureGetItem;
import com.yandex.direct.api.v5.features.FeatureStateEnum;
import com.yandex.direct.api.v5.features.GetRequest;
import com.yandex.direct.api.v5.features.GetResponse;
import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.entity.BaseApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.features.FeaturesEndpoint;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.core.entity.feature.model.FeatureState;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.dbutil.model.ClientId;

@Component
@ParametersAreNonnullByDefault
public class GetFeaturesDelegate
        extends BaseApiServiceDelegate<GetRequest, GetResponse, List<String>, Map<String, FeatureState>> {

    private final FeatureService featureService;

    @Autowired
    public GetFeaturesDelegate(ApiAuthenticationSource auth, FeatureService featureService) {
        super(FeaturesEndpoint.PATH_CONVERTER, auth);
        this.featureService = featureService;
    }

    @Override
    public List<String> convertRequest(GetRequest externalRequest) {
        return externalRequest.getFeatureNames();
    }

    @Override
    public ApiResult<List<Map<String, FeatureState>>> processRequest(List<String> internalRequest) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        Map<String, FeatureState> featureStates = featureService.getFeatureStates(clientId, internalRequest);
        return ApiResult.successful(Collections.singletonList(featureStates));
    }

    @Override
    public GetResponse convertResponse(ApiResult<List<Map<String, FeatureState>>> result) {
        Map<String, FeatureState> featureStatesByName = result.getResult().get(0);
        List<FeatureGetItem> features = EntryStream.of(featureStatesByName)
                .map(this::convertFeature)
                .toList();
        GetResponse getResponse = new GetResponse();
        getResponse.withFeatures(features);
        return getResponse;
    }

    FeatureGetItem convertFeature(Map.Entry<String, FeatureState> feature) {
        FeatureGetItem item = new FeatureGetItem();
        item.setFeatureName(feature.getKey());
        item.setFeatureState(convertState(feature.getValue()));
        return item;
    }

    private FeatureStateEnum convertState(FeatureState state) {
        switch (state) {
            case ENABLED:
                return FeatureStateEnum.ENABLED;
            case DISABLED:
                return FeatureStateEnum.DISABLED;
            default:
                return FeatureStateEnum.UNKNOWN;
        }
    }
}
