package ru.yandex.direct.api.v5.entity.feeds;

import com.yandex.direct.api.v5.feeds.AddRequest;
import com.yandex.direct.api.v5.feeds.AddResponse;
import com.yandex.direct.api.v5.feeds.DeleteRequest;
import com.yandex.direct.api.v5.feeds.DeleteResponse;
import com.yandex.direct.api.v5.feeds.FeedsPort;
import com.yandex.direct.api.v5.feeds.GetRequest;
import com.yandex.direct.api.v5.feeds.GetResponse;
import com.yandex.direct.api.v5.feeds.UpdateRequest;
import com.yandex.direct.api.v5.feeds.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.feeds.delegate.AddFeedsDelegate;
import ru.yandex.direct.api.v5.entity.feeds.delegate.DeleteFeedsDelegate;
import ru.yandex.direct.api.v5.entity.feeds.delegate.GetFeedsDelegate;
import ru.yandex.direct.api.v5.entity.feeds.delegate.UpdateFeedsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class FeedsEndpoint implements FeedsPort {
    private static final String SERVICE_NAME = "feeds";

    private final GenericApiService genericApiService;
    private final AddFeedsDelegate addFeedsDelegate;
    private final GetFeedsDelegate getFeedsDelegate;
    private final UpdateFeedsDelegate updateFeedsDelegate;
    private final DeleteFeedsDelegate deleteFeedsDelegate;

    @Autowired
    public FeedsEndpoint(GenericApiService genericApiService,
                         AddFeedsDelegate addFeedsDelegate,
                         GetFeedsDelegate getFeedsDelegate,
                         UpdateFeedsDelegate updateFeedsDelegate,
                         DeleteFeedsDelegate deleteFeedsDelegate) {
        this.genericApiService = genericApiService;
        this.addFeedsDelegate = addFeedsDelegate;
        this.getFeedsDelegate = getFeedsDelegate;
        this.updateFeedsDelegate = updateFeedsDelegate;
        this.deleteFeedsDelegate = deleteFeedsDelegate;
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) {
        return genericApiService.doAction(addFeedsDelegate, addRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) {
        return genericApiService.doAction(getFeedsDelegate, getRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest updateRequest) {
        return genericApiService.doAction(updateFeedsDelegate, updateRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) {
        return genericApiService.doAction(deleteFeedsDelegate, deleteRequest);
    }
}
