package ru.yandex.direct.api.v5.entity.feeds.converter;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.feeds.BusinessTypeEnum;
import com.yandex.direct.api.v5.feeds.FeedAddItem;
import com.yandex.direct.api.v5.feeds.SourceTypeEnum;
import com.yandex.direct.api.v5.feeds.UrlFeedAdd;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.Feed;
import ru.yandex.direct.core.entity.feed.model.Source;

import static ru.yandex.direct.api.v5.common.GeneralUtil.yesNoToBoolean;

@ParametersAreNonnullByDefault
public class AddRequestConverter {

    private static final Map<BusinessTypeEnum, BusinessType> BUSINESS_TYPE_CORE_BY_API = Map.of(
            BusinessTypeEnum.RETAIL, BusinessType.RETAIL,
            BusinessTypeEnum.HOTELS, BusinessType.HOTELS,
            BusinessTypeEnum.REALTY, BusinessType.REALTY,
            BusinessTypeEnum.AUTOMOBILES, BusinessType.AUTO,
            BusinessTypeEnum.FLIGHTS, BusinessType.FLIGHTS,
            BusinessTypeEnum.OTHER, BusinessType.OTHER
    );

    private static final Map<SourceTypeEnum, Source> SOURCE_TYPE_CORE_BY_API = Map.of(
            SourceTypeEnum.URL, Source.URL,
            SourceTypeEnum.FILE, Source.FILE
    );

    public static List<Feed> convertItemsToModels(List<FeedAddItem> feedItems) {
        return StreamEx.of(feedItems).map(AddRequestConverter::convertItemToModel).toList();
    }

    private static Feed convertItemToModel(FeedAddItem feedItem) {
        SourceTypeEnum sourceType = feedItem.getSourceType();
        Feed feed = new Feed()
                .withName(feedItem.getName())
                .withBusinessType(BUSINESS_TYPE_CORE_BY_API.get(feedItem.getBusinessType()))
                .withSource(SOURCE_TYPE_CORE_BY_API.get(sourceType));
        if (sourceType == SourceTypeEnum.FILE) {
            feed.withFilename(feedItem.getFileFeed().getFilename());
            byte[] data = feedItem.getFileFeed().getData();
            feed.withFileData(data);
        } else if (sourceType == SourceTypeEnum.URL) {
            UrlFeedAdd urlFeed = feedItem.getUrlFeed();
            feed.withUrl(urlFeed.getUrl());
            if (urlFeed.getRemoveUtmTags() != null) {
                feed.withIsRemoveUtm(yesNoToBoolean(urlFeed.getRemoveUtmTags()));
            }
            feed.withLogin(urlFeed.getLogin());
            feed.withPlainPassword(urlFeed.getPassword());
        }
        return feed;
    }
}
