package ru.yandex.direct.api.v5.entity.feeds.delegate;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.feeds.AddRequest;
import com.yandex.direct.api.v5.feeds.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.feeds.converter.AddRequestConverter;
import ru.yandex.direct.api.v5.entity.feeds.validation.FeedsValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.feed.model.Feed;
import ru.yandex.direct.core.entity.feed.service.FeedService;
import ru.yandex.direct.core.entity.user.model.ApiUser;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class AddFeedsDelegate extends OperationOnListDelegate<AddRequest, AddResponse, Feed, Long> {

    private final FeedService feedService;
    private final ResultConverter resultConverter;

    @Autowired
    public AddFeedsDelegate(ApiAuthenticationSource auth,
                            ResultConverter resultConverter,
                            FeedService feedService,
                            PpcPropertiesSupport ppcPropertiesSupport,
                            FeatureService featureService) {
        super(ApiPathConverter.forFeeds(), auth, ppcPropertiesSupport, featureService);
        this.feedService = feedService;
        this.resultConverter = resultConverter;
    }

    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest externalRequest) {
        return FeedsValidationService.validateAdd(externalRequest);
    }

    @Override
    public List<Feed> convertRequest(AddRequest externalRequest) {
        return AddRequestConverter.convertItemsToModels(externalRequest.getFeeds());
    }

    @Override
    public ApiMassResult<Long> processList(List<Feed> feeds) {
        ApiUser chiefSubclient = auth.getChiefSubclient();
        ClientId clientId = chiefSubclient.getClientId();
        Long clientUid = chiefSubclient.getUid();
        Long operatorUid = auth.getOperator().getUid();
        MassResult<Long> idsMassResult = feedService.addFeeds(clientId, clientUid, operatorUid, feeds);
        return resultConverter.toApiMassResult(idsMassResult);
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new AddResponse().withAddResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
