package ru.yandex.direct.api.v5.entity.feeds.delegate;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.feeds.DeleteRequest;
import com.yandex.direct.api.v5.feeds.DeleteResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.feeds.validation.FeedsValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.feed.service.FeedService;
import ru.yandex.direct.core.entity.user.model.ApiUser;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class DeleteFeedsDelegate extends OperationOnListDelegate<DeleteRequest, DeleteResponse, Long, Long> {

    private final FeedService feedService;
    private final ResultConverter resultConverter;

    @Autowired
    public DeleteFeedsDelegate(ApiAuthenticationSource auth,
                               ResultConverter resultConverter,
                               FeedService feedService,
                               PpcPropertiesSupport ppcPropertiesSupport,
                               FeatureService featureService) {
        super(ApiPathConverter.forFeeds(), auth, ppcPropertiesSupport, featureService);
        this.feedService = feedService;
        this.resultConverter = resultConverter;
    }

    @Override
    public ValidationResult<DeleteRequest, DefectType> validateRequest(DeleteRequest externalRequest) {
        return FeedsValidationService.validateDelete(externalRequest);
    }

    @Override
    public List<Long> convertRequest(DeleteRequest externalRequest) {
        return externalRequest.getSelectionCriteria().getIds();
    }

    @Override
    public ApiMassResult<Long> processList(List<Long> feedIds) {
        ApiUser chiefSubclient = auth.getChiefSubclient();
        ClientId clientId = chiefSubclient.getClientId();
        Long clientUid = chiefSubclient.getUid();
        Long operatorUid = auth.getOperator().getUid();
        MassResult<Long> massResult = feedService.deleteFeeds(clientId, clientUid, operatorUid, feedIds);
        return resultConverter.toApiMassResult(massResult);
    }

    @Override
    public DeleteResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new DeleteResponse().withDeleteResults((resultConverter.toActionResults(result, apiPathConverter)));
    }
}
