package ru.yandex.direct.api.v5.entity.feeds.delegate;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.feeds.FeedFieldEnum;
import com.yandex.direct.api.v5.feeds.FileFeedFieldEnum;
import com.yandex.direct.api.v5.feeds.UrlFeedFieldEnum;

@ParametersAreNonnullByDefault
public enum FeedAnyFieldEnum {
    ID(FeedFieldEnum.class, FeedFieldEnum.ID),
    NAME(FeedFieldEnum.class, FeedFieldEnum.NAME),
    BUSINESS_TYPE(FeedFieldEnum.class, FeedFieldEnum.BUSINESS_TYPE),
    SOURCE_TYPE(FeedFieldEnum.class, FeedFieldEnum.SOURCE_TYPE),
    FILTER_SCHEMA(FeedFieldEnum.class, FeedFieldEnum.FILTER_SCHEMA),
    UPDATED_AT(FeedFieldEnum.class, FeedFieldEnum.UPDATED_AT),
    CAMPAIGN_IDS(FeedFieldEnum.class, FeedFieldEnum.CAMPAIGN_IDS),
    NUMBER_OF_ITEMS(FeedFieldEnum.class, FeedFieldEnum.NUMBER_OF_ITEMS),
    STATUS(FeedFieldEnum.class, FeedFieldEnum.STATUS),
    FILENAME(FileFeedFieldEnum.class, FileFeedFieldEnum.FILENAME),
    URL(UrlFeedFieldEnum.class, UrlFeedFieldEnum.URL),
    LOGIN(UrlFeedFieldEnum.class, UrlFeedFieldEnum.LOGIN),
    REMOVE_UTM_TAGS(UrlFeedFieldEnum.class, UrlFeedFieldEnum.REMOVE_UTM_TAGS);

    private final Class<?> enumClass;
    private final Enum value;

    FeedAnyFieldEnum(Class<?> enumClass, Enum value) {
        this.enumClass = enumClass;
        this.value = value;
    }

    public static FeedAnyFieldEnum fromFeedFieldEnum(FeedFieldEnum feedFieldEnum) {
        return getFeedsAnyFieldEnum(feedFieldEnum);
    }

    public static FeedAnyFieldEnum fromFileFeedFieldEnum(FileFeedFieldEnum fileFeedFieldEnum) {
        return getFeedsAnyFieldEnum(fileFeedFieldEnum);
    }

    public static FeedAnyFieldEnum fromUrlFeedFieldEnum(UrlFeedFieldEnum urlFeedFieldEnum) {
        return getFeedsAnyFieldEnum(urlFeedFieldEnum);
    }

    private static <T> FeedAnyFieldEnum getFeedsAnyFieldEnum(T fieldEnum) {
        return Arrays.stream(FeedAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(fieldEnum.getClass()) && v.getValue() == fieldEnum)
                .findFirst()
                .orElseThrow(IllegalStateException::new);
    }

    public Class<?> getEnumClass() {
        return enumClass;
    }

    public Enum getValue() {
        return value;
    }
}
