package ru.yandex.direct.api.v5.entity.feeds.validation;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.feed.validation.FeedDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;

public class FeedDefectTypes {
    private FeedDefectTypes() {
    }

    private static FeedDefectTranslations feedTranslations() {
        return FeedDefectTranslations.INSTANCE;
    }

    public static DefectType feedIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(feedTranslations().feedIsNotSetDetailed());
    }

    public static DefectType feedIdIsNotValid() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(feedTranslations().feedIdIsNotValidDetailed());
    }

    public static DefectType feedUsedInAdGroup() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(feedTranslations().feedUsedInAdGroupDetailed());
    }

    public static DefectType feedStatusWrong(String status) {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(feedTranslations().feedStatusWrongDetailed(status));
    }

    public static DefectType feedNameFieldIsTooLong(Integer maxLength) {
        return DefectTypes.maxStringSize(maxLength)
                .withDetailedMessage(feedTranslations().feedNameFieldIsTooLongDetailed(new Identity(maxLength)));
    }

    public static DefectType feedBodyFieldIsTooLong(Integer maxLength) {
        return DefectTypes.maxStringSize(maxLength)
                .withDetailedMessage(feedTranslations().feedBodyFieldIsTooLongDetailed(new Identity(maxLength)));
    }

    public static DefectType feedInvalidHref() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedInvalidHrefDetailed());
    }

    public static DefectType feedNameCannotBeEmpty() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedNameCannotBeEmptyDetailed());
    }

    public static DefectType feedLoginCannotBeEmpty() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedLoginCannotBeEmptyDetailed());
    }

    public static DefectType feedPasswordCannotBeEmpty() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedPasswordCannotBeEmptyDetailed());
    }

    public static DefectType feedInvalidFilename() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedInvalidFilenameDetailed());
    }

    public static DefectType feedInconsistentType() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(feedTranslations().feedInconsistentTypeDetailed());
    }

    public static DefectType feedNotExist() {
        return DefectTypes.notFound()
                .withDetailedMessage(feedTranslations().feedNotExistDetailed());
    }

    public static DefectType feedLoginIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(feedTranslations().feedLoginIsNotSetDetailed());
    }

    public static DefectType feedPasswordIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(feedTranslations().feedPasswordIsNotSetDetailed());
    }

    public static DefectType feedApartResetLoginAnPassword() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedApartResetLoginAnPasswordDetailed());
    }

    public static DefectType feedBySiteForNotAllowedUrl(String url) {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedBySiteForNotAllowedUrl(url));
    }

    public static DefectType feedBySiteForNotDomainOnlyUrl(String baseUrl, String domainOnlyUrl) {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedBySiteForNotDomainOnlyUrl(baseUrl, domainOnlyUrl));
    }

    public static DefectType feedBySiteContainsDuplicatedUrl(String url) {
        return DefectTypes.duplicatedElement()
                .withDetailedMessage(feedTranslations().feedBySiteContainsDuplicatedUrlDetailed(url));
    }

    public static DefectType feedBySiteWithSameDomainAlreadyExists(long feedId) {
        return DefectTypes.duplicatedElement()
                .withDetailedMessage(feedTranslations()
                        .feedBySiteWithSameDomainAlreadyExistsDetailed(new Identity(feedId)));
    }

    public static DefectType feedCannotBeRefreshedMoreOftenThanRefreshHoursPeriod(long min) {
        return DefectTypes.сantPerform()
                .withDetailedMessage(feedTranslations().feedCannotBeRefreshedMoreOftenThanRefreshHoursPeriod(min));
    }

    public static DefectType feedWithoutUrlSourceCannotBeRefreshed() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedWithoutUrlSourceCannotBeRefreshed());
    }

    public static DefectType feedWithStatusNewCannotBeRefreshed() {
        return DefectTypes.invalidValue()
                .withDetailedMessage(feedTranslations().feedWithStatusNewCannotBeRefreshed());
    }

    public static DefectType feedIsUsedInCampaignBrief() {
        return DefectTypes.сantPerform()
                .withDetailedMessage(feedTranslations().feedIsUsedInCampaignBrief());
    }
}
