package ru.yandex.direct.api.v5.entity.keywordbids;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import one.util.streamex.StreamEx;

@ParametersAreNonnullByDefault
public enum KeywordBidAnyFieldEnum {
    KEYWORD_ID(KeywordBidFieldEnum.KEYWORD_ID),
    AD_GROUP_ID(KeywordBidFieldEnum.AD_GROUP_ID),
    CAMPAIGN_ID(KeywordBidFieldEnum.CAMPAIGN_ID),
    SERVING_STATUS(KeywordBidFieldEnum.SERVING_STATUS),
    STRATEGY_PRIORITY(KeywordBidFieldEnum.STRATEGY_PRIORITY),

    SEARCH_BID(KeywordBidSearchFieldEnum.BID),
    SEARCH_AUCTION_BIDS(KeywordBidSearchFieldEnum.AUCTION_BIDS),

    NETWORK_BID(KeywordBidNetworkFieldEnum.BID),
    NETWORK_COVERAGE(KeywordBidNetworkFieldEnum.COVERAGE);

    private static final Map<Enum, KeywordBidAnyFieldEnum> FIELD_ENUM =
            StreamEx.of(KeywordBidAnyFieldEnum.values()).toMap(KeywordBidAnyFieldEnum::getValue, Function.identity());

    private final Enum value;

    KeywordBidAnyFieldEnum(Enum value) {
        this.value = value;
    }

    private static KeywordBidAnyFieldEnum fromEnum(Enum enumValue) {
        return Optional.ofNullable(FIELD_ENUM.get(enumValue)).orElseThrow(IllegalStateException::new);
    }

    public static KeywordBidAnyFieldEnum fromKeywordBidFieldEnum(KeywordBidFieldEnum keywordBidFieldEnum) {
        return fromEnum(keywordBidFieldEnum);
    }

    public static KeywordBidAnyFieldEnum fromKeywordBidSearchFieldEnum(KeywordBidSearchFieldEnum searchFieldEnum) {
        return fromEnum(searchFieldEnum);
    }

    public static KeywordBidAnyFieldEnum fromKeywordBidNetworkFieldEnum(KeywordBidNetworkFieldEnum networkFieldEnum) {
        return fromEnum(networkFieldEnum);
    }

    public Enum getValue() {
        return value;
    }
}
