package ru.yandex.direct.api.v5.entity.keywordbids;

import com.yandex.direct.api.v5.keywordbids.ApiException;
import com.yandex.direct.api.v5.keywordbids.GetRequest;
import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidsPort;
import com.yandex.direct.api.v5.keywordbids.SetAutoRequest;
import com.yandex.direct.api.v5.keywordbids.SetAutoResponse;
import com.yandex.direct.api.v5.keywordbids.SetRequest;
import com.yandex.direct.api.v5.keywordbids.SetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.keywordbids.delegate.GetKeywordBidsDelegate;
import ru.yandex.direct.api.v5.entity.keywordbids.delegate.SetAutoKeywordBidsDelegate;
import ru.yandex.direct.api.v5.entity.keywordbids.delegate.SetKeywordBidsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class KeywordBidsEndpoint implements KeywordBidsPort {
    private static final String SERVICE_NAME = "keywordbids";

    private final GenericApiService genericApiService;
    private final GetKeywordBidsDelegate getKeywordBidsDelegate;
    private final SetKeywordBidsDelegate setKeywordBidsDelegate;
    private final SetAutoKeywordBidsDelegate setAutoKeywordBidsDelegate;

    @Autowired
    public KeywordBidsEndpoint(GenericApiService genericApiService,
                               GetKeywordBidsDelegate getKeywordBidsDelegate,
                               SetKeywordBidsDelegate setKeywordBidsDelegate,
                               SetAutoKeywordBidsDelegate setAutoKeywordBidsDelegate) {
        this.genericApiService = genericApiService;
        this.getKeywordBidsDelegate = getKeywordBidsDelegate;
        this.setKeywordBidsDelegate = setKeywordBidsDelegate;
        this.setAutoKeywordBidsDelegate = setAutoKeywordBidsDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getKeywordBidsDelegate, getRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "set")
    @ApiResponse
    @Override
    public SetResponse set(@ApiRequest SetRequest setRequest) {
        return genericApiService.doAction(setKeywordBidsDelegate, setRequest);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "setAuto")
    @ApiResponse
    @Override
    public SetAutoResponse setAuto(@ApiRequest SetAutoRequest setAutoRequest) {
        return genericApiService.doAction(setAutoKeywordBidsDelegate, setAutoRequest);
    }
}
