package ru.yandex.direct.api.v5.entity.keywordbids.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.keywordbids.KeywordBidGetItem;
import one.util.streamex.StreamEx;

import ru.yandex.direct.api.v5.entity.keywordbids.KeywordBidAnyFieldEnum;
import ru.yandex.direct.core.entity.auction.container.bs.KeywordTrafaretData;
import ru.yandex.direct.core.entity.bids.container.CompleteBidData;

import static ru.yandex.direct.api.v5.entity.keywordbids.converter.BsAuctionKeywordBidFieldWriter.createBsAuctionKeywordBidFieldWriter;
import static ru.yandex.direct.api.v5.entity.keywordbids.converter.DirectKeywordBidFieldWriter.createDirectKeywordBidFieldWriter;
import static ru.yandex.direct.api.v5.entity.keywordbids.converter.KeywordBidGetItemWriterComposition.writerCompositionOf;
import static ru.yandex.direct.api.v5.entity.keywordbids.converter.PokazometerKeywordBidFieldWriter.createPokazometerKeywordBidFieldWriter;

/**
 * Входная точка для преобразования полученной информации о ставках в список {@link KeywordBidGetItem} для ответа
 */
@ParametersAreNonnullByDefault
public class GetKeywordBidsConverter {

    private GetKeywordBidsConverter() {
    }

    public static List<KeywordBidGetItem> convertCompleteBidDataToKeywordBidGetItems(
            Set<KeywordBidAnyFieldEnum> requiredFields,
            List<CompleteBidData<KeywordTrafaretData>> completeBidData) {
        List<KeywordBidGetItem> result = new ArrayList<>(completeBidData.size());

        KeywordBidGetItemWriter writerComposition = writerCompositionOf(
                createDirectKeywordBidFieldWriter(requiredFields, completeBidData),
                createPokazometerKeywordBidFieldWriter(requiredFields, completeBidData),
                createBsAuctionKeywordBidFieldWriter(requiredFields, completeBidData)
        );

        StreamEx.of(completeBidData)
                .map(CompleteBidData::getBidId)
                .forEach((bidId) -> {
                    KeywordBidGetItem item = new KeywordBidGetItem();
                    writerComposition.write(item, bidId);
                    result.add(item);
                });

        return result;
    }
}
