package ru.yandex.direct.api.v5.entity.keywordbids.converter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.keywordbids.KeywordBidGetItem;
import one.util.streamex.StreamEx;

@ParametersAreNonnullByDefault
public class KeywordBidGetItemWriterComposition implements KeywordBidGetItemWriter {

    private final List<KeywordBidGetItemWriter> writers;

    private KeywordBidGetItemWriterComposition(List<KeywordBidGetItemWriter> writers) {
        this.writers = writers;
    }

    /**
     * Создаёт экземпляр {@link KeywordBidGetItemWriterComposition} с {@code writers}, из которых отфильтрованы {@code null}.
     */
    static KeywordBidGetItemWriterComposition writerCompositionOf(KeywordBidGetItemWriter... writers) {
        return new KeywordBidGetItemWriterComposition(StreamEx.of(writers).nonNull().toList());
    }

    @Override
    public void write(KeywordBidGetItem bid, Long bidId) {
        writers.forEach(w -> w.write(bid, bidId));
    }
}
