package ru.yandex.direct.api.v5.entity.keywordbids.converter;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.keywordbids.Coverage;
import com.yandex.direct.api.v5.keywordbids.KeywordBidGetItem;
import com.yandex.direct.api.v5.keywordbids.Network;
import com.yandex.direct.api.v5.keywordbids.NetworkCoverageItem;
import com.yandex.direct.api.v5.keywordbids.ObjectFactory;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.api.v5.entity.keywordbids.KeywordBidAnyFieldEnum;
import ru.yandex.direct.core.entity.auction.container.bs.KeywordTrafaretData;
import ru.yandex.direct.core.entity.bids.container.CompleteBidData;
import ru.yandex.direct.core.entity.bids.container.KeywordBidDynamicData;
import ru.yandex.direct.core.entity.bids.container.KeywordBidPokazometerData;
import ru.yandex.direct.pokazometer.PhraseResponse;

import static ru.yandex.direct.api.v5.entity.keywordbids.converter.KeywordBidGetItemWriterComposition.writerCompositionOf;


@ParametersAreNonnullByDefault
public class PokazometerKeywordBidFieldWriter implements KeywordBidGetItemWriter {

    private static final ObjectFactory FACTORY = new ObjectFactory();

    private final Set<KeywordBidAnyFieldEnum> requiredFields;
    private final Map<Long, KeywordBidPokazometerData> pokazometerDataByBidId;

    private final KeywordBidGetItemWriter writer;

    private PokazometerKeywordBidFieldWriter(Set<KeywordBidAnyFieldEnum> requiredFields,
                                             Map<Long, KeywordBidPokazometerData> pokazometerDataByBidId) {
        this.requiredFields = requiredFields;
        this.pokazometerDataByBidId = pokazometerDataByBidId;
        writer = writerCompositionOf(getNetworkCoverageWriter());
    }

    static PokazometerKeywordBidFieldWriter createPokazometerKeywordBidFieldWriter(
            Set<KeywordBidAnyFieldEnum> requiredFields,
            Collection<CompleteBidData<KeywordTrafaretData>> completeBidData) {
        Map<Long, KeywordBidPokazometerData> pokazometerDataByBidId =
                StreamEx.of(completeBidData)
                        .mapToEntry(CompleteBidData::getBidId)
                        .invert()
                        .mapValues(CompleteBidData::getDynamicData)
                        .nonNullValues()
                        .mapValues(KeywordBidDynamicData::getPokazometerData)
                        .nonNullValues()
                        .toMap();
        return new PokazometerKeywordBidFieldWriter(requiredFields, pokazometerDataByBidId);
    }


    @Override
    public void write(KeywordBidGetItem bid, Long bidId) {
        writer.write(bid, bidId);
    }

    @Nullable
    private KeywordBidGetItemWriter getKeywordBidGetItemWriter(KeywordBidAnyFieldEnum keywordIdField,
                                                               KeywordBidGetItemWriter keywordIdWriter) {
        return !requiredFields.contains(keywordIdField) ? null : keywordIdWriter;
    }

    @Nullable
    private KeywordBidGetItemWriter getNetworkCoverageWriter() {
        return getKeywordBidGetItemWriter(KeywordBidAnyFieldEnum.NETWORK_COVERAGE, (item, id) -> {
                    KeywordBidPokazometerData pokazometerData = pokazometerDataByBidId.get(id);

                    if (item.getNetwork() == null) {
                        item.setNetwork(new Network());
                    }

                    // заполняем Coverage = null, если параметр был запрошен, но от Показометра не пришли данные
                    Coverage coverage = null;
                    if (pokazometerData != null) {
                        coverage = new Coverage().withCoverageItems(
                                EntryStream.of(pokazometerData.getCoverageWithPrices())
                                        .mapKeys(PhraseResponse.Coverage::getPercentage)
                                        .reverseSorted(Comparator.comparingInt(Map.Entry::getKey))
                                        .mapKeyValue((probability, price) -> new NetworkCoverageItem()
                                                .withBid(price.micros())
                                                .withProbability(BigDecimal.valueOf(probability)))
                                        .collect(Collectors.toList())
                        );
                    }
                    item.getNetwork().setCoverage(FACTORY.createNetworkCoverage(coverage));
                }
        );
    }
}
