package ru.yandex.direct.api.v5.entity.keywords;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

public interface KeywordsTranslations extends TranslationBundle {
    KeywordsTranslations INSTANCE = I18NBundle.implement(KeywordsTranslations.class);

    @MessageFormatStub("Ключевое слово не найдено")
    Translatable keywordNotFoundDetailed();

    @MessageFormatStub("Группа объявлений не найдена")
    Translatable adGroupNotFoundDetailed();

    @MessageFormatStub("Разрешено добавлять не более {0} ключевых слов в одном запросе")
    Translatable maxElementsPerKeywordsAddDetailed(Identity max);

    @MessageFormatStub("Разрешено изменять не более {0} ключевых слов в одном запросе")
    Translatable maxElementsPerKeywordsUpdateDetailed(Identity max);

    @MessageFormatStub("Разрешено удалять не более {0} ключевых слов в одном запросе")
    Translatable maxElementsPerKeywordsDeleteDetailed(Identity max);

    @MessageFormatStub("Ключевое слово не может присутствовать в запросе более одного раза")
    Translatable keywordIsDuplicatedDetailed();

    @MessageFormatStub("Id ключевого слова не может присутствовать в запросе более одного раза")
    Translatable keywordIdCanNotDuplicatedDetailed();

    @MessageFormatStub("Id ключевого слова присутствует в запросе более одного раза")
    Translatable keywordIdIsDuplicatedDetailed();

    @MessageFormatStub("Группа объявлений может содержать не более {0} ключевых слов")
    Translatable maxKeywordsInAdGroupDetailed(Identity maxKeywordsInAdGroup);

    @MessageFormatStub("Группа объявлений может содержать не более одного автотаргетинга")
    Translatable maxAutotargetingsInAdGroupDetailed();

    @MessageFormatStub("Группа объявлений может содержать не более одного офферного ретаргетинга")
    Translatable maxOfferRetargetingsInAdGroupDetailed();

    @MessageFormatStub("Нельзя вычитать слово - ({0}), содержащееся в исходной ключевой фразе ({1})")
    Translatable keywordCouldNotBeUsedAsMinusWord(String minusWords, String keyword);

    @MessageFormatStub("Нельзя вычитать слово - ({0}), содержащееся в исходной ключевой фразе \"{1}\"")
    Translatable keywordCouldNotBeUsedAsMinusWordQuot(String minusWords, String keyword);

    @MessageFormatStub("Ключевая фраза не может состоять только из минус-слов \"{0}\"")
    Translatable keywordCouldNotBeContainedMinusWord(String minusWords);

    @MessageFormatStub("Из ключевой фразы могут вычитаться только отдельные слова, а не словосочетания \"{0}\"")
    Translatable minusWordsNoMinusPhrasesDetailed(String minusPhrase);

    @MessageFormatStub("В тексте ключевых фраз разрешается использовать только буквы английского, турецкого, казахского, русского, украинского или белорусского алфавита, кавычки, знаки \"-\", \"+\", \"!\", пробел. Ошибка в ключевой фразе \"{0}\"")
    Translatable keywordMustContainValidSymbols(String keyword);

    @MessageFormatStub("Внутри скобок [] не допустимы модификаторы +-\"\", ключевая фраза \"{0}\"")
    Translatable invalidCharsModifiersInsideSquareBrackets(String value);

    @MessageFormatStub("В ключевой фразе \"{0}\" присутствуют недопустимые модификаторы +-\"\" внутри скобок []")
    Translatable keywordContainsInvalidModifiersInsideSquareBrackets(String value);

    @MessageFormatStub("Неправильное сочетание специальных символов в ключевой фразе \"{0}\"")
    Translatable incorrectCombinationOfSpecialChars(String value);

    @MessageFormatStub("Квадратные скобки [] не могут быть пустыми и вложеными, ключевая фраза \"{0}\"")
    Translatable incorrectCombinationOfSquareBrackets(String value);

    @MessageFormatStub("Превышена допустимая длина отдельного ключевого слова в {0} символов. Ошибки в словах: {1}.")
    Translatable keywordMaxLengthDetailedWords(int maxLength, String keyword);

    @MessageFormatStub("Превышена допустимая длина отдельного минус-слова в {0} символов. Ошибки в словах: {1}.")
    Translatable minusWordMaxLengthOnlyDetailed(int maxLength, String minusWord);

    @MessageFormatStub("Ключевая фраза не может состоять более чем из {0} слов \"{1}\"")
    Translatable maxWordsDetailed(int maxWords, String keyword);

    @MessageFormatStub("Неправильное использование кавычек в ключевой фразе \"{0}\"")
    Translatable invalidQuotes(String phrase);

    @MessageFormatStub("Ключевая фраза не может состоять только из стоп-слов: союзов, предлогов, частиц \"{0}\"")
    Translatable onlyStopWords(String phrase);

    @MessageFormatStub("Превышена допустимая длина строки в {0} символов в ключевой фразе \"{1}\"")
    Translatable keywordsTooLongDetailed(String maxLength, String phrase);

    @MessageFormatStub("Ставка {0} не будет применена, так как отключены показы на поиске")
    Translatable bidWontBeAcceptedSearchIsSwitchedOff(Path path);

    @MessageFormatStub("Запрещено задавать категории автотаргетинга в указанной группе объявлений")
    Translatable autotargetingCategoriesForbiddenInThisAdGroup();
}
