package ru.yandex.direct.api.v5.entity.keywords;

import java.util.List;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;

import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidChars;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxStringSize;
import static ru.yandex.direct.api.v5.validation.DefectTypes.minusWords;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notFound;

public class MinusPhraseDefectTypes {

    private MinusPhraseDefectTypes() {
    }

    public static DefectType illegalMinusKeywordChars() {
        return DefectTypes.invalidChars().withDetailedMessage(translations().notAllowedSymbolsInMinusKeywordDetailed());
    }

    public static DefectType illegalMinusKeywordCharsDetailed(List<String> keywords) {
        return DefectTypes.invalidChars().withDetailedMessage(
                translations().notAllowedSymbolsInMinusKeywordDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType maxLengthMinusKeywords(int maxLength) {
        return maxStringSize(maxLength)
                .withDetailedMessage(translations().maxLengthMinusKeywordsDetailed(new Identity(maxLength)));
    }

    public static DefectType invalidWordFirstCharacter(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().invalidWordFirstCharacterDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType invalidWordFirstCharacter() {
        return minusWords().withDetailedMessage(
                (path, value) -> translations().invalidWordFirstCharacterDetailedWithListQuotes(value.toString()));
    }

    public static DefectType invalidDot() {
        return invalidChars().withDetailedMessage(translations().invalidDotDetailed());
    }

    public static DefectType invalidDotDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().invalidDotDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType separateDotDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().separateDotDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType wrongQuotes() {
        return invalidChars().withDetailedMessage(translations().wrongWrappedQuotesInMinusKeywordDetailed());
    }

    public static DefectType wrongQuotesDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().wrongWrappedQuotesInMinusKeywordDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType maxLengthMinusWord(int maxMinusWordLength) {
        return maxStringSize(maxMinusWordLength).withDetailedMessage(
                translations().maxLengthWordInMinusKeywordDetailed(new Identity(maxMinusWordLength)));
    }

    public static DefectType maxLengthMinusWordDetailed(int maxMinusWordLength, List<String> keywords) {
        return new DefectType(5162, translations().maxWordLengthInMinusKeywordMessage(),
                translations().maxLengthWordInMinusKeywordDetailedWithList(new Identity(maxMinusWordLength),
                        String.join(", ", keywords)));
    }

    public static DefectType maxCountWordsInKeyword(int maxLength) {
        return maxStringSize(maxLength)
                .withDetailedMessage(translations().maxWordsCountInKeywordDetailed(new Identity(maxLength)));
    }

    public static DefectType maxCountWordsInKeywordDetailed(int maxLength, List<String> keywords) {
        return invalidChars()
                .withDetailedMessage(translations().maxWordsCountInKeywordDetailedWithList(new Identity(maxLength),
                        String.join(", ", keywords)));
    }

    public static DefectType invalidSquareBrackets() {
        return invalidChars().withDetailedMessage(translations().invalidSquareBracketsDetailed());
    }

    public static DefectType imbalancedSquareBracketsDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().imbalancedSquareBracketsDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType nestedOrEmptySquareBracketsDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().nestedOrEmptySquareBracketsDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType invalidOperatorsInsideSquareBrackets() {
        return invalidChars().withDetailedMessage(translations().notAllowedOperatorsInsideBracketsDetailed());
    }

    public static DefectType invalidOperatorsInsideSquareBracketsDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().notAllowedOperatorsInsideBracketsDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType invalidExclamationMark() {
        return invalidChars().withDetailedMessage(translations().wrongExclamationMarkInMinusKeyword());
    }

    public static DefectType invalidExclamationMarkDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().wrongExclamationMarkInMinusKeywordDetailed(String.join(", ", keywords)));
    }

    public static DefectType invalidMinusMark() {
        return invalidChars().withDetailedMessage(translations().wrongMinusMarkUsageInMinusKeywordDetailed());
    }

    public static DefectType invalidMinusMarkDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().wrongMinusMarkUsageInMinusKeywordDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType invalidPlusMark() {
        return invalidChars().withDetailedMessage(translations().wrongPlusMarkUsageInMinusKeywordDetailed());
    }

    public static DefectType invalidPlusMarkDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().wrongPlusMarkUsageInMinusKeywordDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType invalidCombinationSpecialSymbols() {
        return invalidChars().withDetailedMessage(translations().wrongSpecialSymbolsUsageInMinusKeywordDetailed());
    }

    public static DefectType invalidCombinationOfSpecialSymbolsDetailed(List<String> keywords) {
        return invalidChars().withDetailedMessage(
                translations().wrongSpecialSymbolsUsageInMinusKeywordDetailedWithList(String.join(", ", keywords)));
    }

    public static DefectType minusWordsPackNotFound() {
        return notFound().withDetailedMessage((path, id) -> translations().minusWordsPackNotFound(new Identity((Long) id)));
    }

    public static MinusPhraseDefectTranslations translations() {
        return MinusPhraseDefectTranslations.INSTANCE;
    }

    public static DefectType negativeKeywordSetsLimitExceeded(Number max) {
        return DefectTypes.invalidValue().withDetailedMessage(
                translations().negativeKeywordSetsLimitExceededDetailed(max.intValue()));
    }
}
