package ru.yandex.direct.api.v5.entity.keywords.container;

import javax.annotation.Nullable;

import com.google.common.base.Preconditions;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;

public class AddInputItem {
    private final Keyword keyword;
    private final RelevanceMatch relevanceMatch;
    private final boolean priorityIsSetForManualStrategy;

    private AddInputItem(Keyword keyword, RelevanceMatch relevanceMatch, boolean priorityIsSetForManualStrategy) {
        Preconditions.checkArgument(keyword == null ^ relevanceMatch == null);
        this.keyword = keyword;
        this.relevanceMatch = relevanceMatch;
        this.priorityIsSetForManualStrategy = priorityIsSetForManualStrategy;
    }

    public static AddInputItem createItemForKeyword(Keyword keyword, boolean priorityIsSetForManualStrategy) {
        return new AddInputItem(keyword, null, priorityIsSetForManualStrategy);
    }

    public static AddInputItem createItemForRelevanceMatch(RelevanceMatch relevanceMatch,
                                                           boolean priorityIsSetForManualStrategy) {
        return new AddInputItem(null, relevanceMatch, priorityIsSetForManualStrategy);
    }

    public boolean hasKeyword() {
        return keyword != null;
    }

    public Keyword getKeyword() {
        if (keyword == null) {
            throw new IllegalStateException("no keyword here");
        }
        return keyword;
    }

    public boolean hasRelevanceMatch() {
        return relevanceMatch != null;
    }

    public RelevanceMatch getRelevanceMatch() {
        if (relevanceMatch == null) {
            throw new IllegalStateException("no relevanceMatch here");
        }
        return relevanceMatch;
    }

    public Boolean getPriorityIsSetForManualStrategy() {
        return priorityIsSetForManualStrategy;
    }

    @Nullable
    public Long getAdGroupId() {
        return keyword != null ? keyword.getAdGroupId() : relevanceMatch.getAdGroupId();
    }
}
