package ru.yandex.direct.api.v5.entity.keywords.container;

import java.util.Objects;

/**
 * Описывает входящий элемент для метода Keywords.delete. Кроме непосредственно идентификатора, содержит ещё
 * и информацию что под этим идентификатором скрывается: ключевая фраза или безфразный таргетинг.
 */
public class DeleteInputItem {
    private final long id;
    private final boolean hasKeywordId;

    private DeleteInputItem(long id, boolean hasKeywordId) {
        this.id = id;
        this.hasKeywordId = hasKeywordId;
    }

    public static DeleteInputItem createItemForKeyword(long id) {
        return new DeleteInputItem(id, true);
    }

    public static DeleteInputItem createItemForRelevanceMatch(long id) {
        return new DeleteInputItem(id, false);
    }

    public boolean hasKeywordId() {
        return hasKeywordId;
    }

    public Long getHasKeywordId() {
        if (!hasKeywordId) {
            throw new IllegalStateException("no keyword here");
        }
        return id;
    }

    public boolean hasRelevanceMatchId() {
        return !hasKeywordId;
    }

    public Long getRelevanceMatchId() {
        if (hasKeywordId) {
            throw new IllegalStateException("no relevanceMatch here");
        }
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteInputItem that = (DeleteInputItem) o;
        return id == that.id &&
                hasKeywordId == that.hasKeywordId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, hasKeywordId);
    }
}
