package ru.yandex.direct.api.v5.entity.keywords.container;


import javax.annotation.Nullable;

import com.google.common.base.Preconditions;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;

public class KeywordsGetContainer {

    private final Keyword keyword;
    private final RelevanceMatch relevanceMatch;

    private KeywordsGetContainer(Keyword keyword, RelevanceMatch relevanceMatch) {
        Preconditions.checkArgument(keyword == null ^ relevanceMatch == null);
        this.keyword = keyword;
        this.relevanceMatch = relevanceMatch;
    }

    public static KeywordsGetContainer createItemForKeyword(Keyword keyword) {
        return new KeywordsGetContainer(keyword, null);
    }

    public static KeywordsGetContainer createItemForRelevanceMatch(RelevanceMatch relevanceMatch) {
        return new KeywordsGetContainer(null, relevanceMatch);
    }

    public Keyword getKeyword() {
        return keyword;
    }

    public RelevanceMatch getRelevanceMatch() {
        return relevanceMatch;
    }

    @Nullable
    public Long getId() {
        return keyword != null ? keyword.getId() : relevanceMatch.getId();
    }

    @Nullable
    public Long getAdGroupId() {
        return keyword != null ? keyword.getAdGroupId() : relevanceMatch.getAdGroupId();
    }

    @Nullable
    public Long getCampaignId() {
        return keyword != null ? keyword.getCampaignId() : relevanceMatch.getCampaignId();
    }

    public boolean hasKeyword() {
        return keyword != null;
    }

    public boolean hasRelevanceMatch() {
        return relevanceMatch != null;
    }

}
