package ru.yandex.direct.api.v5.entity.keywords.container;


import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Аггрегатор статистики показов/кликов на поиске и в сетях.
 */

@ParametersAreNonnullByDefault
public class StatValueAggregatorItem {
    private Long searchClicks;
    private Long searchShows;
    private Long networkClicks;
    private Long networkShows;

    public Long getSearchClicks() {
        return searchClicks;
    }

    public StatValueAggregatorItem withSearchClicks(Long searchClicks) {
        this.searchClicks = searchClicks;
        return this;
    }

    public Long getSearchShows() {
        return searchShows;
    }

    public StatValueAggregatorItem withSearchShows(Long searchShows) {
        this.searchShows = searchShows;
        return this;
    }

    public Long getNetworkClicks() {
        return networkClicks;
    }

    public StatValueAggregatorItem withNetworkClicks(Long networkClicks) {
        this.networkClicks = networkClicks;
        return this;
    }

    public Long getNetworkShows() {
        return networkShows;
    }

    public StatValueAggregatorItem withNetworkShows(Long networkShows) {
        this.networkShows = networkShows;
        return this;
    }
}
