package ru.yandex.direct.api.v5.entity.keywords.container;

import javax.annotation.Nullable;

import com.google.common.base.Preconditions;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.model.ModelChanges;

public final class UpdateInputItem {
    private final ModelChanges<Keyword> keywordChanges;
    private final ModelChanges<RelevanceMatch> relevanceMatchChanges;

    private UpdateInputItem(ModelChanges<Keyword> keywordChanges, ModelChanges<RelevanceMatch> relevanceMatchChanges) {
        Preconditions.checkArgument(keywordChanges == null ^ relevanceMatchChanges == null);
        this.keywordChanges = keywordChanges;
        this.relevanceMatchChanges = relevanceMatchChanges;
    }

    public static UpdateInputItem createItemForKeyword(ModelChanges<Keyword> keywordChanges) {
        return new UpdateInputItem(keywordChanges, null);
    }

    public static UpdateInputItem createItemForRelevanceMatch(ModelChanges<RelevanceMatch> relevanceMatchChanges) {
        return new UpdateInputItem(null, relevanceMatchChanges);
    }

    public boolean hasKeywordChanges() {
        return keywordChanges != null;
    }

    public ModelChanges<Keyword> getKeywordChanges() {
        if (keywordChanges == null) {
            throw new IllegalStateException("no keywordChanges here");
        }
        return keywordChanges;
    }

    public boolean hasRelevanceMatchChanges() {
        return relevanceMatchChanges != null;
    }

    public ModelChanges<RelevanceMatch> getRelevanceMatchChanges() {
        if (relevanceMatchChanges == null) {
            throw new IllegalStateException("no relevanceMatchChanges here");
        }
        return relevanceMatchChanges;
    }

    @Nullable
    public Long getId() {
        return keywordChanges != null ? keywordChanges.getId() : relevanceMatchChanges.getId();
    }
}
