package ru.yandex.direct.api.v5.entity.keywords.converter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.general.IdsCriteria;
import com.yandex.direct.api.v5.keywords.DeleteRequest;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.entity.keywords.container.DeleteInputItem;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class KeywordsDeleteRequestConverter {
    private final RelevanceMatchService relevanceMatchService;

    public KeywordsDeleteRequestConverter(RelevanceMatchService relevanceMatchService) {
        this.relevanceMatchService = relevanceMatchService;
    }

    public List<DeleteInputItem> convertRequest(DeleteRequest request, ClientId clientId) {
        return convertIdsCriteria(request.getSelectionCriteria(), clientId);
    }

    private List<DeleteInputItem> convertIdsCriteria(IdsCriteria idsCriteria, ClientId clientId) {
        Set<Long> requestIds = idsCriteria.getIds().stream()
                // Идентификаторы приходят извне, поэтому могут быть некорректыми и дублироваться. Слегка почистим.
                .filter(id -> id > 0)
                .collect(Collectors.toSet());
        Set<Long> clientRelevanceMatchIds = relevanceMatchService.getRelevanceMatchIds(clientId, requestIds);
        return convertIdsCriteria(idsCriteria, clientRelevanceMatchIds);
    }

    private List<DeleteInputItem> convertIdsCriteria(IdsCriteria idsCriteria, Set<Long> clientRelevanceMatchIds) {
        return mapList(idsCriteria.getIds(), i -> convertItem(i, clientRelevanceMatchIds));
    }

    private DeleteInputItem convertItem(Long id, Set<Long> clientRelevanceMatchIds) {
        if (clientRelevanceMatchIds.contains(id)) {
            return DeleteInputItem.createItemForRelevanceMatch(id);
        } else {
            return DeleteInputItem.createItemForKeyword(id);
        }
    }
}
