package ru.yandex.direct.api.v5.entity.keywords.converter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.general.IdsCriteria;
import com.yandex.direct.api.v5.keywords.ResumeRequest;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.entity.keywords.container.UpdateInputItem;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class KeywordsResumeRequestConverter {
    private final RelevanceMatchService relevanceMatchService;

    public KeywordsResumeRequestConverter(RelevanceMatchService relevanceMatchService) {
        this.relevanceMatchService = relevanceMatchService;
    }

    /**
     * Сконвертировать запрос на возобновление показов по ключевым фразам и автотаргетингам в внутреннее
     * представление: запроса обновления этих сущностей, где выставлен флаг IS_SUSPENDED
     * <p>
     * Подразумевается, что на конвертацию приходит валидный с точки зрения операции запрос, т.е. все идентификаторы
     * в нём, не равны null.
     */
    public List<UpdateInputItem> convertRequest(ResumeRequest request, ClientId clientId) {
        Set<Long> requestIds = request.getSelectionCriteria().getIds().stream()
                .filter(id -> id > 0)
                .collect(Collectors.toSet());
        Set<Long> clientRelevanceMatchIds = relevanceMatchService.getRelevanceMatchIds(clientId, requestIds);
        return convertRequest(request.getSelectionCriteria(), clientRelevanceMatchIds);
    }

    // todo zakhar: выделить общий для suspend / resume компонент
    public List<UpdateInputItem> convertRequest(IdsCriteria idsCriteria, Set<Long> clientRelevanceMatchIds) {
        return mapList(idsCriteria.getIds(), i -> convertItem(i, clientRelevanceMatchIds));
    }

    // todo zakhar: тесты
    UpdateInputItem convertItem(Long id, Set<Long> clientRelevanceMatchIds) {
        if (clientRelevanceMatchIds.contains(id)) {
            return UpdateInputItem.createItemForRelevanceMatch(convertRelevanceMatch(id));
        } else {
            return UpdateInputItem.createItemForKeyword(convertKeywordItem(id));
        }
    }

    ModelChanges<Keyword> convertKeywordItem(Long keywordId) {
        ModelChanges<Keyword> changes = new ModelChanges<>(keywordId, Keyword.class);
        changes.process(false, Keyword.IS_SUSPENDED);
        return changes;
    }

    ModelChanges<RelevanceMatch> convertRelevanceMatch(Long relevanceMatchId) {
        ModelChanges<RelevanceMatch> changes = new ModelChanges<>(relevanceMatchId, RelevanceMatch.class);
        changes.process(false, RelevanceMatch.IS_SUSPENDED);
        return changes;
    }
}
