package ru.yandex.direct.api.v5.entity.keywords.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.general.IdsCriteria;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.keywords.KeywordsDefectTypes.maxElementsPerKeywordsUpdate;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.eachNotNull;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;

@Component
@ParametersAreNonnullByDefault
public class KeywordsIdsCriteriaValidator {
    static final int MAX_ELEMENTS = 10_000;

    public ValidationResult<IdsCriteria, DefectType> validate(IdsCriteria idsCriteria) {
        ItemValidationBuilder<IdsCriteria, DefectType> vb = ItemValidationBuilder.of(idsCriteria);
        vb.item(idsCriteria.getIds(), IdsCriteria.PropInfo.IDS.schemaName.getLocalPart())
                .check(eachNotNull())
                .check(maxListSize(MAX_ELEMENTS), maxElementsPerKeywordsUpdate(MAX_ELEMENTS));
        return vb.getResult();
    }
}
