package ru.yandex.direct.api.v5.entity.keywordsresearch;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;

import static ru.yandex.direct.api.v5.validation.DefectTypes.translations;

public class AdvqDefectTypes {

    public static DefectType cannotContainsOnlyMinusWords() {
        return DefectTypes.minusWords();
    }

    public static DefectType containsOnlyStopWords() {
        return DefectTypes.containsOnlyStopWords();
    }

    public static DefectType incorrectUseOfMinusSign() {
        return DefectTypes.invalidChars().withDetailedMessage(
                (path, value) -> translations().invalidCharsIncorrectUseOfMinusSign(value.toString()));
    }

    public static DefectType minusWordsCannotSubtractPlusWords() {
        return DefectTypes.minusWords().withDetailedMessage(
                (path, value) -> translations().minusWordsCantSubtractPlusWords(path));
    }

    public static DefectType noMinusPhrasesOnlyWords() {
        return DefectTypes.minusWords().withDetailedMessage(
                (path, value) -> translations().minusWordsNoMinusPhrasesDetailed(path));
    }

    public static DefectType tooLongKeyword(int maxLength) {
        return DefectTypes.keywordMaxLength(maxLength);
    }

    public static DefectType tooManyWords(int maxWords) {
        return DefectTypes.maxWords(maxWords);
    }

    public static DefectType unpairedQuotes() {
        return DefectTypes.invalidChars().withDetailedMessage(
                (path, value) -> translations().invalidCharsUnpairedQuotesDetailed(value.toString()));
    }

    public static DefectType unpairedSquareBrackets() {
        return DefectTypes.invalidChars().withDetailedMessage(
                (path, value) -> translations().invalidCharsUnpairedSquareBracketsDetailed(value.toString()));
    }

    public static DefectType modifiersInsideSquareBrackets() {
        return DefectTypes.invalidChars().withDetailedMessage(
                (path, value) -> translations().invalidCharsModifiersInsideSquareBrackets(value.toString()));
    }

    public static DefectType invalidUseOfDot() {
        return DefectTypes.invalidChars().withDetailedMessage(
                (path, value) -> translations().invalidDot(path));
    }

    public static DefectType bothQuotesAndMinusWords() {
        return DefectTypes.minusWords().withDetailedMessage(
                (path, value) -> translations().bothQuotesAndMinusWords(path));
    }

    public static DefectType invalidChars() {
        return DefectTypes.invalidChars();
    }
}
