package ru.yandex.direct.api.v5.entity.keywordsresearch;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.advqphrase.AdvqPhraseDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;

public class DeduplicateDefectTypes {
    private DeduplicateDefectTypes() {}

    private static AdvqPhraseDefectTranslations advqTranslations() {
        return AdvqPhraseDefectTranslations.INSTANCE;
    }
    private static CommonDefectTranslations commonTranslations() { return CommonDefectTranslations.INSTANCE; }

    public static DefectType cannotContainsOnlyMinusWords() {
        return DefectTypes.minusWords().withDetailedMessage(advqTranslations().minusWordsOnlyDetailed());
    }

    public static DefectType containsOnlyStopWords() {
        return DefectTypes.containsOnlyStopWords().withDetailedMessage(advqTranslations().stopWordsDetailed());
    }

    public static DefectType incorrectUseOfMinusSign() {
        return DefectTypes.invalidChars().withDetailedMessage(advqTranslations().invalidCharsIncorrectUseOfMinusSign());
    }

    public static DefectType minusWordsCannotSubtractPlusWords(String minusWords) {
        return DefectTypes.minusWords().withDetailedMessage(
                (path, value) -> advqTranslations().minusWordsCantSubtractPlusWords(minusWords));
    }

    public static DefectType noMinusPhrasesOnlyWords() {
        return DefectTypes.minusWords().withDetailedMessage(advqTranslations().minusWordsNoMinusPhrasesDetailed());
    }

    public static DefectType tooLongKeyword(int maxLength) {
        return DefectTypes.keywordMaxLength(maxLength);
    }

    public static DefectType tooManyWords(int maxWords) {
        return DefectTypes.maxWords(maxWords).withDetailedMessage(advqTranslations().maxWordsDetailed(maxWords));
    }

    public static DefectType unpairedQuotes() {
        return DefectTypes.invalidChars().withDetailedMessage(advqTranslations().invalidCharsUnpairedQuotesDetailed());
    }

    public static DefectType unpairedSquareBrackets() {
        return DefectTypes.invalidChars().withDetailedMessage(
                advqTranslations().invalidCharsUnpairedSquareBracketsDetailed());
    }

    public static DefectType modifiersInsideSquareBrackets() {
        return DefectTypes.invalidChars().withDetailedMessage(
                (path, value) -> commonTranslations().invalidCharsModifiersInsideSquareBrackets(value.toString()));
    }

    public static DefectType invalidUseOfDot() {
        return DefectTypes.invalidChars().withDetailedMessage(advqTranslations().invalidDot());
    }

    public static DefectType bothQuotesAndMinusWords() {
        return DefectTypes.minusWords().withDetailedMessage(advqTranslations().bothQuotesAndMinusWords());
    }

    public static DefectType invalidChars() {
        return DefectTypes.invalidChars();
    }

    public static DefectType incorrectUseOfPlusSign() {
        return DefectTypes.invalidChars().withDetailedMessage(advqTranslations().invalidCharsIncorrectUseOfPlusSign());
    }

    public static DefectType incorrectUseOfExclamationSign() {
        return DefectTypes.invalidChars().withDetailedMessage(
                advqTranslations().invalidCharsIncorrectUseOfExclamationMarks());
    }
}
