package ru.yandex.direct.api.v5.entity.keywordsresearch;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateRequest;
import com.yandex.direct.api.v5.keywordsresearch.DeduplicateResponse;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeRequest;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import com.yandex.direct.api.v5.keywordsresearch.KeywordsResearchPort;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.keywordsresearch.delegate.DeduplicateDelegate;
import ru.yandex.direct.api.v5.entity.keywordsresearch.delegate.HasSearchVolumeDelegate;
import ru.yandex.direct.api.v5.ratelimit.RateLimitByApplication;
import ru.yandex.direct.api.v5.ratelimit.RateLimitByClient;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.AGENCY_AND_CLIENT)
public class KeywordsResearchEndpoint implements KeywordsResearchPort {
    private static final String SERVICE_NAME = "keywordsresearch";

    private final GenericApiService service;
    private final HasSearchVolumeDelegate hasSearchVolumeDelegate;
    private final DeduplicateDelegate deduplicateDelegate;

    @Autowired
    public KeywordsResearchEndpoint(GenericApiService service,
                                    HasSearchVolumeDelegate hasSearchVolumeDelegate,
                                    DeduplicateDelegate deduplicateDelegate) {
        this.service = service;
        this.hasSearchVolumeDelegate = hasSearchVolumeDelegate;
        this.deduplicateDelegate = deduplicateDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "hasSearchVolume")
    @ApiResponse
    @Override
    @RateLimitByClient(periodInSeconds = 60, maxRequests = 20)
    @RateLimitByApplication(periodInSeconds = 60)
    public HasSearchVolumeResponse hasSearchVolume(@ApiRequest HasSearchVolumeRequest parameters) {
        return service.doAction(hasSearchVolumeDelegate, parameters);
    }

    @PreAuthorizeRead
    @Override
    @ApiMethod(service = SERVICE_NAME, operation = "deduplicate")
    @ApiResponse
    public DeduplicateResponse deduplicate(@ApiRequest DeduplicateRequest parameters) {
        return service.doAction(deduplicateDelegate, parameters);
    }
}
