package ru.yandex.direct.api.v5.entity.keywordsresearch.delegate;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateRequestItem;

import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

import static ru.yandex.direct.libs.keywordutils.parser.KeywordParser.parseWithMinuses;

@ParametersAreNonnullByDefault
public class DeduplicateKeywordItem {
    private final DeduplicateRequestItem requestItem;
    private KeywordWithMinuses parsedKeyword;

    public DeduplicateKeywordItem(DeduplicateRequestItem requestItem) {
        this.requestItem = requestItem;
    }

    @Nullable
    public Long getId() {
        return requestItem.getId();
    }

    public String getKeyword() {
        return requestItem.getKeyword();
    }

    public KeywordWithMinuses getParsedKeyword() {
        if (parsedKeyword == null) {
            parsedKeyword = parseWithMinuses(getKeyword());
        }
        return parsedKeyword;
    }

    @Nullable
    public Long getWeight() {
        return requestItem.getWeight();
    }
}
