package ru.yandex.direct.api.v5.entity.keywordsresearch.delegate;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.keyword.processing.ProcessedKeyword;

@ParametersAreNonnullByDefault
public class DeduplicateKeywordResponse {
    private final Long id;
    private final ProcessedKeyword keyword;
    private final Long weight;
    private final boolean isDuplicate;

    public DeduplicateKeywordResponse(@Nullable Long id,
                                      ProcessedKeyword keyword,
                                      @Nullable Long weight,
                                      boolean isDuplicate) {
        this.id = id;
        this.keyword = keyword;
        this.weight = weight;
        this.isDuplicate = isDuplicate;
    }

    @Nullable
    public Long getId() {
        return id;
    }

    public ProcessedKeyword getKeyword() {
        return keyword;
    }

    public Long getWeight() {
        return weight;
    }

    public boolean isDuplicate() {
        return isDuplicate;
    }
}
