package ru.yandex.direct.api.v5.entity.keywordsresearch.service;

import java.util.List;
import java.util.Set;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;

public class HasSearchVolumeInnerRequest {
    private final List<String> keywords;
    private final List<Long> regionIds;
    private final Set<HasSearchVolumeFieldEnum> fields;

    public HasSearchVolumeInnerRequest(List<String> keywords,
                                       List<Long> regionIds,
                                       Set<HasSearchVolumeFieldEnum> fields) {
        this.keywords = keywords;
        this.regionIds = regionIds;
        this.fields = fields;
    }

    public List<String> getKeywords() {
        return keywords;
    }

    public List<Long> getRegionIds() {
        return regionIds;
    }

    public Set<HasSearchVolumeFieldEnum> getFields() {
        return fields;
    }

    @Override
    public String toString() {
        return "HasSearchVolumeInnerRequest{" +
                "keywords:" + keywords + "," +
                "regionIds:" + regionIds + "," +
                "fields:" + fields + "}";
    }
}
