package ru.yandex.direct.api.v5.entity.keywordsresearch.service;

import java.util.List;
import java.util.Set;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;

import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.ALL_DEVICES;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.KEYWORD;
import static com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum.REGION_IDS;

public class KeywordSearchVolumes {
    private String keyword;
    private List<Long> regionIds;
    private YesNoEnum allDevices;
    private YesNoEnum mobilePhones;
    private YesNoEnum tablets;
    private YesNoEnum desktops;


    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Long> getRegionIds() {
        return regionIds;
    }

    public void setRegionIds(List<Long> regionIds) {
        this.regionIds = regionIds;
    }

    public YesNoEnum getAllDevices() {
        return allDevices;
    }

    public void setAllDevices(YesNoEnum allDevices) {
        this.allDevices = allDevices;
    }

    public YesNoEnum getMobilePhones() {
        return mobilePhones;
    }

    public void setMobilePhones(YesNoEnum mobilePhones) {
        this.mobilePhones = mobilePhones;
    }

    public YesNoEnum getTablets() {
        return tablets;
    }

    public void setTablets(YesNoEnum tablets) {
        this.tablets = tablets;
    }

    public YesNoEnum getDesktops() {
        return desktops;
    }

    public void setDesktops(YesNoEnum desktops) {
        this.desktops = desktops;
    }

    public static KeywordSearchVolumes from(String keyword, List<Long> regionIds, Set<HasSearchVolumeFieldEnum> fields) {
        // Заполняем поля keyword и regionIds, инициализируем поле impressionsOnAllDevices
        KeywordSearchVolumes item = new KeywordSearchVolumes();

        if (fields.contains(KEYWORD)) {
            item.setKeyword(keyword);
        }
        if (fields.contains(REGION_IDS)) {
            item.setRegionIds(regionIds);
        }
        if (fields.contains(ALL_DEVICES)) {
            item.setAllDevices(YesNoEnum.NO);
        }

        return item;
    }
}
