package ru.yandex.direct.api.v5.entity.leads;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.leads.ApiException;
import com.yandex.direct.api.v5.leads.GetRequest;
import com.yandex.direct.api.v5.leads.GetResponse;
import com.yandex.direct.api.v5.leads.LeadsPort;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.leads.delegate.GetLeadsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
@ParametersAreNonnullByDefault
public class LeadsEndpoint implements LeadsPort {
    private static final String SERVICE_NAME = "leads";

    public static final PathConverter PATH_CONVERTER = MappingPathConverter.builder(LeadsEndpoint.class, "")
            .add(ApiPathConverter.getCommonDict())
            .build();

    private final GenericApiService genericApiService;
    private final GetLeadsDelegate getLeadsDelegate;

    @Autowired
    public LeadsEndpoint(GenericApiService genericApiService,
                         GetLeadsDelegate getLeadsDelegate) {
        this.genericApiService = genericApiService;
        this.getLeadsDelegate = getLeadsDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getLeadsDelegate, getRequest);
    }
}
